package transactiondemo.server;

import javax.ejb.*;
import javax.naming.*;
import javax.jms.*;
import java.rmi.RemoteException;

import java.util.*;

import containerdemo.interfaces.CustomerBean;
import containerdemo.interfaces.CustomerBeanHome;

/**
 * @ejb:bean type="Stateless"
 *           name="TransactionBean"
 *           jndi-name="ejb/TransactionBean"
 *           transaction-type="Container"
 *
 * @author markw@markwatson.com
 */
public abstract class TransactionBean implements SessionBean {

    /**
     * @ejb:interface-method view-type="remote"
     * @ejb:transaction type="Required"
     */
    public void testTransaction(String newName) throws Exception {
	try {
	    InitialContext lContext = new InitialContext();
	    CustomerBeanHome lHome = (CustomerBeanHome) lContext.lookup("ejb/CustomerBean");
	    lHome.create("222","Carol","carol@cc.com");
	    lHome.create("227","Julie","julie@cc.com");
	    // try to create a customer with a zero length id: this will throw an error:
	    //lHome.create("", "Mary", "mary@cc.com");
	    lHome.create("229","David","david@cc.com");
	} catch (Exception e) {
	    throw new EJBException("Transaction failed: " + e);
	}
    }
}
