import javax.naming.InitialContext;
import javax.naming.Context;
import java.util.Hashtable;

import sessiondemo.interfaces.PrimeBean;
import sessiondemo.interfaces.PrimeBeanHome;

public class TestClient {

    public static void main(String[] args){
	try {
	    Hashtable env = new Hashtable();
	    env.put(Context.INITIAL_CONTEXT_FACTORY,
		    "org.jnp.interfaces.NamingContextFactory");
	    env.put(Context.PROVIDER_URL, "localhost:1099");
	    env.put("java.naming.factory.url.pkgs",
		    "org.jboss.naming:org.jnp.interfaces");
	    InitialContext lContext = new InitialContext(env);
         
	    PrimeBeanHome lHome = (PrimeBeanHome) lContext.lookup( "ejb/PrimeBean" );
	    PrimeBean primeBean = lHome.create();
	    for (long i=3; i<2000; i++) {
		if (primeBean.checkPrime(i)) {
		    System.out.println("" + i + " is a prime number");
		}
	    }
	    primeBean.remove();
	} catch( Exception e ){
	    e.printStackTrace();
	}
    }
}
