import junit.framework.TestCase;

import javax.naming.InitialContext;
import javax.naming.Context;
import java.util.Hashtable;

import sessiondemo.interfaces.PrimeBean;
import sessiondemo.interfaces.PrimeBeanHome;

public class TestSessionPrimeEjb extends TestCase {
    public TestSessionPrimeEjb(String test) {
        super(test);
    }

    /** * The fixture set up called before every test method. */
    protected void setUp() throws Exception {
    }

    /** * The fixture clean up called after every test method. */
    protected void tearDown() throws Exception {
    }

    public void testSomething() throws Exception {

	Hashtable env = new Hashtable();
	env.put(Context.INITIAL_CONTEXT_FACTORY,
		"org.jnp.interfaces.NamingContextFactory");
	env.put(Context.PROVIDER_URL, "localhost:1099");
	env.put("java.naming.factory.url.pkgs",
		"org.jboss.naming:org.jnp.interfaces");
	InitialContext lContext = new InitialContext(env);
         
	PrimeBeanHome lHome = (PrimeBeanHome) lContext.lookup( "ejb/PrimeBean" );
	PrimeBean primeBean = lHome.create();
	assertTrue(primeBean.checkPrime(13));
	assertFalse(primeBean.checkPrime(21));
	primeBean.remove();

    }
}
