package sessiondemo.server;

import javax.ejb.SessionBean;

/**
 * @ejb:bean type="Stateless"
 *           name="PrimeBean"
 *           jndi-name="ejb/PrimeBean"
 *
 * @author markw@markwatson.com
 */
public abstract class PrimeBean implements SessionBean {

    /**
     * @ejb:interface-method view-type="remote"
     */
    public boolean checkPrime(long number) {
        if (number < 3) return false;
        long half = number / 2;
        for (long i=3; i<half; i+=2) {
            if ((number/i)*i == number) return false;
        }
        return true;
    }
}