import javax.naming.InitialContext;
import javax.naming.Context;
import java.util.Hashtable;
import javax.jms.*;

public class TestClient {

    public static void main(String[] args){
	try {
	    Hashtable env = new Hashtable();
	    env.put(Context.INITIAL_CONTEXT_FACTORY,
		    "org.jnp.interfaces.NamingContextFactory");
	    env.put(Context.PROVIDER_URL, "localhost:1099");
	    env.put("java.naming.factory.url.pkgs",
		    "org.jboss.naming:org.jnp.interfaces");
	    InitialContext lContext = new InitialContext(env);
         Queue queue = (Queue) lContext.lookup("queue/CheckPrime");
        QueueConnectionFactory qcf = (QueueConnectionFactory) lContext.lookup("ConnectionFactory");
        lContext.close();

        QueueConnection qc = qcf.createQueueConnection();
        QueueSession qs = qc.createQueueSession(true, 0);
        QueueSender qsend = qs.createSender(queue);
        TextMessage msg = qs.createTextMessage();
        msg.setText("13");
        qsend.send(msg);
        qs.commit();
        qc.close();
	} catch( Exception e ){
	    e.printStackTrace();
	}
    }
}
