package message.prime;

import javax.ejb.*;
import javax.jms.*;
import javax.naming.*;

public class PrimeMessageBean
    implements MessageDrivenBean, MessageListener {

    public void onMessage(Message msg) {
        TextMessage textMessage = (TextMessage)msg;
        try {
            String numberText = textMessage.getText();
            String requestorName = textMessage.getStringProperty("requestorName");
            System.out.println("$$ PrimeMessageBean:\n     requestor name: " + requestorName);
            long num = -1;
            try {
                num = Long.parseLong(numberText);
                System.out.println("     number: " + num);
                System.out.println("     prime status: " + checkPrime(num));
            } catch (Exception e) {
                System.out.println("     number: " + numberText + " is not a valid number format.");
            }
        }
        catch(JMSException ex) {
            ex.printStackTrace();
        }
    }

    private boolean checkPrime(long number) {
        if (number < 3) return false;
        long half = number / 2;
        for (long i=3; i<half; i+=2) {
            if ((number/i)*i == number) return false;
        }
        return true;
    }

    public void ejbCreate() {
    }

    public void ejbRemove() {
    }

    public void setMessageDrivenContext(MessageDrivenContext ctx) {
        this.ctx = ctx;
    }
    private MessageDrivenContext ctx;
}
