import javax.naming.InitialContext;
import javax.naming.Context;
import java.util.*;

import containerdemo.interfaces.CustomerBean;
import containerdemo.interfaces.CustomerBeanHome;

public class TestClient {

    public static void main(String[] args){
	try {
	    Hashtable env = new Hashtable();
	    env.put(Context.INITIAL_CONTEXT_FACTORY,
		    "org.jnp.interfaces.NamingContextFactory");
	    env.put(Context.PROVIDER_URL, "localhost:1099");
	    env.put("java.naming.factory.url.pkgs",
		    "org.jboss.naming:org.jnp.interfaces");
	    InitialContext lContext = new InitialContext(env);
         
	    CustomerBeanHome lHome = (CustomerBeanHome) lContext.lookup( "ejb/CustomerBean" );

	    try {
		CustomerBean customerBean = lHome.findByPrimaryKey("123");
		String name = customerBean.getName();
		String email = customerBean.getEmail();
		System.out.println("Name: " + name + ", email: " + email);
		// change the email address in the database:
		customerBean.setEmail(email+".com");
		System.out.println("Modified email in database: " + customerBean.getEmail());
		// change the email back to the original value:
		customerBean.setEmail(email);
		// create a new Customer (i.e., create a new row in table):
		lHome.create("222","Carol","carol@cc.com");
		customerBean = lHome.findByPrimaryKey("222");
		name = customerBean.getName();
		email = customerBean.getEmail();
		System.out.println("New customer: name: " + name + ", email: " + email);
		// delete this new customer from the database:
		customerBean.remove();
	    } catch (Exception e) {
		System.out.println("Error for findByPrimaryKey(): " + e);
	    }
	} catch( Exception e ){
	    e.printStackTrace();
	}
    }
}
