package containerdemo.server;

import javax.ejb.*;

/**
 * @ejb:bean type="CMP"
 *           cmp-version="2.x"
 *           name="CustomerBean"
 *           jndi-name="ejb/CustomerBean"
 *           primkey-field="id"
 *           view-type="both"
 *
 * @ejb.transaction type="Required"
 *
 * @ejb.pk class="java.lang.String" generate="true"
 *
 * @jboss.cmp-field field-name="id" column-name="id"
 *
 * @author markw@markwatson.com
 */
public abstract class CustomerBean implements EntityBean {

    public void setEntityContext(EntityContext c) { }
    public void ejbActivate() { }
    public void ejbLoad() { }
    public void ejbStore() { }
    public void ejbRemove() { }

    /**
     * @ejb.create-method
     */
    public String ejbCreate(String id, String name, String email) throws javax.ejb.CreateException {
        if (id.length() < 1) throw new CreateException("id must not be a zero length string");
	setId(id);
	setName(name);
	setEmail(email);
	return id;
    }


    public void ejbPostCreate(String id, String name, String email) throws javax.ejb.CreateException {
       // would set CMR fields here (if we were using them)
    }

    /**
     * @ejb.persistence column-name="id"
     * @ejb.interface-method
     * @ejb.persistent-field
     */
    public abstract void setId(String id);
  
    /**
     * @ejb.persistence column-name="id"
     * @ejb.interface-method
     * @ejb.persistent-field
     */
    public abstract String getId();
  
    /**
     * @ejb.interface-method
     * @ejb.persistence column-name="name"
     * @ejb.persistent-field
     */
    public abstract String getName();
  
    /**
     * @ejb.interface-method
     * @ejb.persistence column-name="name"
     * @ejb.persistent-field
     */
    public abstract void setName(String name);

  
    /**
     * @ejb.interface-method
     * @ejb.persistence column-name="email"
     * @ejb.persistent-field
     */
    public abstract String getEmail();
  
    /**
     * @ejb.interface-method
     * @ejb.persistence column-name="email"
     * @ejb.persistent-field
     */
    public abstract void setEmail(String email);
}
