
import javax.servlet.http.*;
import javax.servlet.ServletException;
import java.io.PrintWriter;
import java.util.Enumeration;

public class UserServlet extends HttpServlet {

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        doPost(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        PrintWriter out = null;
        try {
            out = res.getWriter();
        } catch (Exception e2) {
        }
        res.setContentType("text/html");
        out.println("<html><head><title>User Servlet</title></head><body>");
        // check session data:
        out.println("<H2>Curent Session Data</H2>");
        HttpSession session = req.getSession();
        Enumeration enum = session.getAttributeNames();
        out.println("<UL>");
        while (enum.hasMoreElements()) {
            String name = (String) enum.nextElement();
            String value = (String) session.getAttribute(name);
            out.println("  <LI>" + name + " : " + value + "</LI>");
        }
        out.println("</UL>");
        // check cookie data:
        Cookie[] cookies = req.getCookies();
        out.println("<H2>Cookie Data</H2>");
        if (cookies != null) {
            for (int i = 0; i < cookies.length; i++) {
                String comment = cookies[i].getComment();
                String domain = cookies[i].getDomain();
                String value = cookies[i].getValue();
                String name = cookies[i].getName();
                String path = cookies[i].getPath();
                out.println("<h3>" + name + " has value: " + value + "</h3>");
                out.println("comment: " + comment + ", domain: " + domain + ", path: " + path);
            }
        }
        // print out the HTML FORM to the output stream:
        out.println("<FORM action=\"/S43/user\" method=\"GET\">");
        out.println(" <SELECT NAME=\"Hobbies\" size=5>");
        out.println("  <OPTION VALUE=\"movies\">movies</OPTION>");
        out.println("  <OPTION VALUE=\"music\">music</OPTION>");
        out.println("  <OPTION VALUE=\"cooking\">cooking</OPTION>");
        out.println("  <OPTION VALUE=\"hiking\">hiking</OPTION>");
        out.println("  <OPTION VALUE=\"reading\">reading</OPTION>");
        out.println(" </SELECT>");
        out.println(" <INPUT TYPE=\"text\" NAME=\"name\" size=\"60\" />");
        out.println("  <BR />");
        out.println(" <INPUT TYPE=\"submit\" NAME=\"doit\" VALUE=\"enter name\" />");
        out.println("</FORM>");

        String name = req.getParameter("name");
        if (name != null && name.length() > 0) {
            // make a new cookie:
            Cookie cookie = new Cookie("name", name);
            // if you do not set an age, then the cookie will not be available
            // in a future session:
            cookie.setMaxAge(3600); // 1 hour
            res.addCookie(cookie);
            // add session data:
            session.setAttribute("name", name);
        }
        String hobby = req.getParameter("Hobbies");
        if (hobby != null) {
            System.out.println("hobby: " + hobby);
            // make a new cookie:
            Cookie cookie = new Cookie("hobby", hobby);
            cookie.setMaxAge(3600); // 1 hour
            res.addCookie(cookie);
            // add session data:
            session.setAttribute("hobby", hobby);
        }
        out.println("</body>");
        out.println("</HTML>");
        return;
    }
}
