package primes;

/**
 * This class pre-calculates the lower prime numbers
 * and uses these cached primes to more quickly test for "primeness".
 */
public class CheckPrime {
    public final int MAX_CACHE = 5000;
    private long[] cache = new long[MAX_CACHE];
    private int count = 0;
    public CheckPrime() {
    }
    public void initCache() {
	cache[count++] = 2;
	cache[count++] = 3;
	long test = 5;
	while (count < (MAX_CACHE-1)) {
	    if (check(test) == 0) {
		cache[count++] = test;
		//System.out.println(" prime: " + test);
	    }
	    test += 2; // only test odd numbers after 2
	}
	System.out.println("number primes cached="+count);
    }
    public long check(long num) {  // return 0 if prime, otherwise return a prime factor
	if (num == 1) return 0;
	for (int i=0; i<count; i++) {
	    if (num == cache[i]) return 0;
	    long test = (num / cache[i]) * cache[i];
	    if (test == num) return cache[i];
	}
	return 0;
    }
    public boolean cacheReady() {
	return count == (MAX_CACHE -1);
    }
    public static void main(String[] args) {
	new CheckPrime().initCache();
    }
}
