
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletException;
import javax.servlet.ServletConfig;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Date;

public class PrimeServlet extends HttpServlet {

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        doPost(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        PrintWriter out = null;
        try {
            out = res.getWriter();
        } catch (Exception e2) {
        }
        res.setContentType("text/html");
        out.println("<html><head><title>Prime Servlet</title></head><body>");
        out.println("<h2>Enter test data and select 'submit data'</h2>");
        // print out the HTML FORM to the output stream:
        out.println("<FORM action=\"/S42/prime\" method=\"POST\">");
        out.println("  <INPUT TYPE=\"text\" NAME=\"query\" size=\"60\" />");
        out.println("  <BR />");
        out.println("  <INPUT TYPE=\"submit\" NAME=\"doit\" VALUE=\"check prime\" />");
        out.println("</FORM>");

        String query = req.getParameter("query");
        if (query != null && query.length() > 0) {
            try {
                // the following statement will throw an error on an incorrect number format:
                long number = Long.parseLong(query);
                // see if caching of prime numbers is complete:
                if (checkPrime==null || checkPrime.cacheReady() == false) {
                    out.println("<h2>Prime Number Cache is not initialized - try again</h2>");
                } else {
                    long primeFactor = checkPrime.check(number);
                    if (primeFactor == 0) {
                        out.println("<h2>" + number + " is a prime number</h2>");
                    } else {
                        out.println("<h2>" + number + " is a not prime number. A prime factor is " +
                                    primeFactor + "</h2>");
                    }
                }
            } catch (Exception ee) {
                out.println("<p>Servlet error: " + ee + "</p>");
            }
        }
        out.println("</body>");
        out.println("</HTML>");
        return;
    }
    primes.CheckPrime checkPrime = null;
    public void init(ServletConfig config) throws ServletException {
        System.out.println("entering PrimeServlet.init(...)");
        super.init(config);
        (new CachePrimesThread()).start();
        System.out.println("  leaving with PrimeServlet.init()");
    }

    class CachePrimesThread extends Thread {
        public void run() {
            // class loading of CheckPrime class causes static initialization:
            checkPrime = new primes.CheckPrime();
            checkPrime.initCache();
        }
    }
}
