package demo;

import net.sf.hibernate.cfg.Configuration;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;

import java.sql.Connection;
import java.sql.DriverManager;

import pojo.Customer;

public class TestWrite {
    public static void main(String[] args) throws Exception, HibernateException {
        Class.forName("org.postgresql.Driver");
        Connection conn = DriverManager.getConnection("jdbc:postgresql://localhost:5432/test?user=postgres");
        System.out.println("conn=" + conn);
        Configuration cfg = new Configuration().addClass(Customer.class); // addFile("Customer.hbm.xml");
        SessionFactory sessions = cfg.buildSessionFactory();
        Session sess = sessions.openSession(conn);
        Customer mark = new Customer();
        mark.setId(123);
        mark.setName("Mark");
        mark.setEmail("mark@cc.zzz.com");
        mark.setPhone("111-2222");
        Object obj = sess.save(mark);
        System.out.println("return id from save: " + obj + ", class: " + obj.getClass());
        // create a few more test objects and persist them:
        for (int i = 1; i < 5; i++) {
            Customer c = new Customer();
            c.setName("name" + i);
            c.setEmail("");
            c.setPhone("" + i + i + i + "-" + i + i + i + i);
            c.setId(i);
            sess.save(c);
        }
        sess.flush();
        sess.close();
    }
}
