package demo;

import net.sf.hibernate.HibernateException;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.Session;
import net.sf.hibernate.FlushMode;
import net.sf.hibernate.cfg.Configuration;

import java.sql.Connection;
import java.sql.DriverManager;

import pojo.Customer;

public class TestRead {
    public static void main(String[] args) throws Exception, HibernateException {
        Class.forName("org.postgresql.Driver");
        Connection conn = DriverManager.getConnection("jdbc:postgresql://localhost:5432/test?user=postgres");
        System.out.println("conn=" + conn);
        Configuration cfg = new Configuration().addClass(Customer.class); // addFile("Customer.hbm.xml");
        SessionFactory sessions = cfg.buildSessionFactory();
        Session sess = sessions.openSession(conn);
	System.out.println("Default flush mode: " + sess.getFlushMode());
	sess.setFlushMode(FlushMode.NEVER);
        Customer cust = (Customer) sess.load(Customer.class, new Integer(123));
        System.out.println("cust name:" + cust.getName());
        sess.flush();
        sess.close();
    }
}
