package demo;

import net.sf.hibernate.HibernateException;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.Session;
import net.sf.hibernate.Query;
import net.sf.hibernate.cfg.Configuration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.List;
import java.util.Iterator;

import pojo.Customer;

public class TestQuery {
    public static void main(String[] args) throws Exception, HibernateException {
        Class.forName("org.postgresql.Driver");
        Connection conn = DriverManager.getConnection("jdbc:postgresql://localhost:5432/test?user=postgres");
        System.out.println("conn=" + conn);
        Configuration cfg = new Configuration().addClass(Customer.class); // addFile("Customer.hbm.xml");
        SessionFactory sessions = cfg.buildSessionFactory();
        Session sess = sessions.openSession(conn);
        String s;

        s = "from c in class Customer where c.name='Mark'";
        System.out.println(s);
        Query q = sess.createQuery(s);
        q.setProperties(new Customer());
        List ll = q.list();
        Iterator iter = ll.iterator();
        while (iter.hasNext()) {
            Customer c = (Customer)iter.next();
            System.out.println(c.toString());
        }

        s = "from c in class Customer where c.id < 3";
        System.out.println(s);
        q = sess.createQuery(s);
        q.setProperties(new Customer());
        ll = q.list();
        iter = ll.iterator();
        while (iter.hasNext()) {
            Customer c = (Customer)iter.next();
            System.out.println(c.toString());
        }

        s = "from c in class Customer where c.name in ('Mark', 'name4')";
        System.out.println(s);
        q = sess.createQuery(s);
        q.setProperties(new Customer());
        ll = q.list();
        iter = ll.iterator();
        while (iter.hasNext()) {
            Customer c = (Customer)iter.next();
            System.out.println(c.toString());
        }

        s = "from Customer";
        System.out.println(s);
        q = sess.createQuery(s);
        q.setProperties(new Customer());
        ll = q.list();
        iter = ll.iterator();
        while (iter.hasNext()) {
            Customer c = (Customer)iter.next();
            System.out.println(c.toString());
        }

        sess.flush();
        sess.close();
    }
}
