package S39;

import S35S36.JdbcInitialization;
import S35S36.JdbcUtilApis;

import java.sql.*;

/**
 * User: markw
 * Date: Sep 16, 2003
 * Time: 3:02:43 PM
 */
public class MetadataExample {
    public static void main(String[] args) {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            // initialze JDBC and ensure three example tables are created:
            new JdbcInitialization();

            conn = DriverManager.getConnection(JdbcInitialization.DBurl);
            stmt = conn.createStatement();
            // printout to see concrete class name:
            System.out.println("Concrete DatabaseMetaData class: " + conn.getMetaData());

            DatabaseMetaData metaData = conn.getMetaData();
            printResultSet("Catalogs", metaData.getCatalogs());
            printResultSet("Schemas", metaData.getSchemas());
            printResultSet("Tables for catalog 'test'", metaData.getTables("test", null, null, null));
            printResultSet("Tables for catalog 'test' table 'customer'", metaData.getTables("test", null, "customer", null));
            printResultSet("Columns for database test table customer:", metaData.getColumns("test", null, "customer", null));
            printTableColumns(metaData, "test", "customer");
            printTableColumns(metaData, "test", "product");
            printTableColumns(metaData, "test", "inventory");
        } catch (Exception ee) {
            System.out.println("Error : " + ee);
        } finally {
            if (rs != null) {
                try {
                    rs.close();
                } catch (Exception e) {
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (Exception e) {
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                } catch (Exception e) {
                }
            }
        }
    }

    public static void printResultSet(String title, ResultSet rs) {
        System.out.println("\nResult Set: " + title + "\n");
        try {
            ResultSetMetaData rsMetaData = rs.getMetaData();
            int num = rsMetaData.getColumnCount();
            // print column names:
            for (int i = 0; i < num; i++) {
                String columnName = rsMetaData.getColumnName(i + 1);
                System.out.print("\t" + columnName);
            }
            System.out.println();
            while (rs.next()) {
                System.out.print("new row : ");
                for (int i = 0; i < num; i++) {
                    String s = rs.getString(i + 1);
                    System.out.print(s + "\t");
                }
                System.out.println();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    public static void printTableColumns(DatabaseMetaData metaData,
                                         String database, String table)
            throws Exception {
        ResultSet rs = metaData.getColumns(database, null, table, null);
        ResultSetMetaData rsMetaData = rs.getMetaData();
        int num = rsMetaData.getColumnCount();
        // print column names:
        System.out.println("\nDatabase: " + database + "\ttable: " + table + "\nColumn names and types:");
        while (rs.next()) {
            String columnName = rs.getString(4);
            String typeName = rs.getString(6);
            System.out.println("\t" + columnName + "\t" + typeName);
        }
    }
}
