package S37;

import S35S36.JdbcInitialization;
import S35S36.JdbcUtilApis;

import java.sql.DriverManager;
import java.sql.Connection;
import java.sql.Statement;
import java.sql.SQLException;

/**
 * User: markw
 * Date: Sep 16, 2003
 * Time: 10:18:05 AM
 */
public class BatchUpdateExample {
    public static void main(String[] args) {
        Connection conn = null;
        Statement stmt = null;
        try {
            // initialze JDBC and ensure three example tables are created:
            new JdbcInitialization();
            // delete any data that is alread in the test database:
            (new JdbcUtilApis()).removeAllData();
            conn = DriverManager.getConnection(JdbcInitialization.DBurl);
            stmt = conn.createStatement();
            stmt.addBatch("insert into product values (10001, 'Anti-virus program', 29.95)");
            stmt.addBatch("insert into product values (10002, 'Disk-Defrag program', 39.95)");
            // test: throw an exception on purpose:
            //stmt.addBatch("insert into UNKNOWN_TABLE values (1, 2, 3)");
            stmt.addBatch("insert into product values (10003, 'Undelete-File program', 19.95)");
            int[] rowsChanged = stmt.executeBatch();
            for (int i = 0; i < rowsChanged.length; i++) {
                System.out.println(" rows changed: " + rowsChanged[i]);
            }
        } catch (Exception batchOrSqlException) {
            System.out.println("Error during batch update: " + batchOrSqlException);
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (Exception e) {
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                } catch (Exception e) {
                }
            }
        }
    }
}
