package S35S36;

import java.sql.ResultSet;
import java.sql.DriverManager;
import java.sql.Statement;
import java.sql.Connection;

/**
 * User: markw
 * Date: Sep 13, 2003
 * Time: 11:55:11 AM
 */

/**
 * This is a utility class to access the tables:
 *
 *   1. Customer (customerID int PRIMARY KEY, name varchar, address varchar, email varchar, phone varchar)
 *   2. Product (productID int PRIMARY KEY, name varchar, cost float)
 *   3. Inventory (productID int PRIMARY KEY, count int)
 */
public class JdbcUtilApis {

    //  Demo: remove all rows from all three tables:

    public void removeAllData() {
        doUpdate("delete from customer");
        doUpdate("delete from product");
        doUpdate("delete from inventory");
    }
    //  Demo: adding data to 3 example tables:

    public int addCustomer(String name, String address, String email, String phone) {
        int key = generateRandomKey("customer");
        int rowCount = doUpdate("insert into customer VALUES(" + key + ", '" +
                name + "', '" + address + "', '" + email +
                "', '" + phone + "')");
        if (rowCount > 0) return key;
        return -1; // error code
    }

    public int addProduct(String name, float cost) {
        int key = generateRandomKey("product");
        int rowCount = doUpdate("insert into product VALUES(" + key + ", '" +
                name + "', " + cost + ")");
        if (rowCount > 0) return key;
        return -1; // error code
    }

    public int addInventory(int key, int count) {
        int rowCount = doUpdate("insert into inventory VALUES(" + key + ", " + count + ")");
        if (rowCount == 1) return key;
        return -1; // error code
    }

    //  Demo: deleting data from 3 example tables:

    public int deleteCustomer(int customerID) {
        int rowsDeletedCount =
                doUpdate("delete from customer where customerID=" + customerID);
        return rowsDeletedCount;
    }

    public int deleteProduct(int productID) {
        int rowsDeletedCount =
                doUpdate("delete from product where productID=" + productID);
        return rowsDeletedCount;
    }


    public int deleteInventory(int productID) {
        int rowsDeletedCount =
                doUpdate("delete from inventory where productID=" + productID);
        return rowsDeletedCount;
    }

    // Demo: update inventory count:

    public int updateInventory(int productID, int newCount) {
        int rowsModifiedCount =
                doUpdate("UPDATE inventory SET count=" + newCount + " where productID=" + productID);
        return rowsModifiedCount;
    }

    //  Demo: utility to get inventory count:

    public int getInventoryCount(int productID) {
        int count = 0;
        ResultSet rs = null;
        Connection conn = null;
        Statement stmt = null;

        try {
            conn = DriverManager.getConnection(JdbcInitialization.DBurl);
            stmt = conn.createStatement();
            rs = stmt.executeQuery("select count from inventory where productID=" + productID);
            if (rs != null && rs.next()) {
                count = rs.getInt(1);
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (rs != null) {
                try {
                    rs.close();
                } catch (Exception e2) {
                }
            }
            if (stmt != null) {
                try {
                    //stmt.close();
                } catch (Exception e2) {
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                } catch (Exception e2) {
                }
            }

        }
        return count;
    }

    private int generateRandomKey(String tableName) {
        int key = -1;
        ResultSet rs = null;
        Connection conn = null;
        Statement stmt = null;
        while (true) {
            long m = System.currentTimeMillis() + (long) (10001 * Math.random());
            key = (int) (m % 31001);
            try {
                conn = DriverManager.getConnection(JdbcInitialization.DBurl);
                stmt = conn.createStatement();
                rs = stmt.executeQuery("select name from " + tableName + " where " +
                        tableName + "ID=" + key);

                if (rs == null) break;
                if (rs != null && rs.next() == false) break;
            } catch (Exception ee) {
                ee.printStackTrace();
            } finally {
                if (rs != null) {
                    try {
                        rs.close();
                    } catch (Exception e2) {
                    }
                }
                if (stmt != null) {
                    try {
                        //stmt.close();
                    } catch (Exception e2) {
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    } catch (Exception e2) {
                    }
                }

            }
        }
        return key;
    }

    public Customer getCustomerData(int customerID) {
        Customer customer = new Customer();
        ResultSet rs = null;
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = DriverManager.getConnection(JdbcInitialization.DBurl);
            stmt = conn.createStatement();
            rs = stmt.executeQuery("select name, address, email, phone from customer where customerID=" + customerID);
            if (rs.next()) {
                customer.setCustomerID(customerID);
                customer.setName(rs.getString(1));
                customer.setAddress(rs.getString(2));
                customer.setEmail(rs.getString(3));
                customer.setPhone(rs.getString(4));
            }
        } catch (Exception ee) {
            ee.printStackTrace(System.err);
        } finally {
            if (rs != null) {
                try {
                    rs.close();
                } catch (Exception e2) {
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (Exception e2) {
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                } catch (Exception e2) {
                }
            }

        }
        return customer;
    }

    public Product getProductInfo(int productID) {
        Product product = new Product();
        ResultSet rs = null;
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = DriverManager.getConnection(JdbcInitialization.DBurl);
            stmt = conn.createStatement();
            rs = stmt.executeQuery("select name from product where productID=" + productID);
            if (rs.next()) {
                product.setProductID(productID);
                product.setName(rs.getString(1));
            }
            rs.close();
            rs = stmt.executeQuery("select count from inventory where productID=" + productID);
            if (rs.next()) {
                product.setNumberInInventory(rs.getInt(1));
            }
        } catch (Exception ee) {
            ee.printStackTrace(System.err);
        } finally {
            if (rs != null) {
                try {
                    rs.close();
                } catch (Exception e2) {
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (Exception e2) {
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                } catch (Exception e2) {
                }
            }

        }
        return product;
    }

    private int doUpdate(String updateSQL) {
        int count = 0;
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = DriverManager.getConnection(JdbcInitialization.DBurl);
            stmt = conn.createStatement();
            count = stmt.executeUpdate(updateSQL);
        } catch (Exception ee) {
            ee.printStackTrace(System.err);
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (Exception e2) {
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                } catch (Exception e2) {
                }
            }
        }
        return count;
    }

}
