package S35S36;

import java.sql.Connection;
import java.sql.Statement;
import java.sql.DriverManager;

/**
 * User: markw
 * Date: Sep 13, 2003
 * Time: 11:01:25 AM
 */
public class JdbcInitialization {

    /**
     * Default constructor - applications that use this class should
     * create an instance - this will cause the JVM class loader to
     * load this class. During class loading, the static initialization
     * is performed.
     *
     * NOTE: if you set Java properties like:
     *
     *   System.setProperty("DBurl", "jdbc:postgresql://localhost:5432/test5?user=postgres");
     * you should do this before creating an instance of this class: this will
     * insure that the static code in this class is executed in an environment
     * where your Java properties have already been set.
     */
    public JdbcInitialization() {
    }

    public static String DBurl = "jdbc:postgresql://localhost:5432/test?user=postgres";
    public static String DBdriver = "org.postgresql.Driver";

    static {
        /**
         * Check to see if parameters are set to override defaults:
         */
        try {
            DBurl = System.getProperty("DBurl", DBurl);
            DBdriver = System.getProperty("DBdriver", DBdriver);
        } catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Class.forName(DBdriver).newInstance();
        } catch (Exception e) {
            System.err.println("Could not open JDBC driver " +
                    DBdriver);
            e.printStackTrace();
        }

        Connection conn = null;
        Statement stmt = null;

        try {
            conn = DriverManager.getConnection(DBurl);
            stmt = conn.createStatement();
            stmt.executeQuery("select * from customer where customerID=-1");
        } catch (Exception any) {
            /**
             * Check to see if the sample table 'customer' is created. If the
             * table does not exist, then create it.
             */
            try {
                System.out.println("We probably need to create the table 'customer'. Error thrown was: " + any);
                stmt.executeUpdate("create table customer (customerID int PRIMARY KEY, name varchar, address varchar, email varchar, phone varchar)");
            } catch (Exception e2) {
            }
        } finally {
            try {
                stmt.close();
            } catch (Exception ee) {
            }
            try {
                conn.close();
            } catch (Exception ee) {
            }
        }
        try {
            conn = DriverManager.getConnection(DBurl);
            stmt = conn.createStatement();
            stmt.executeQuery("select * from product where productID=-1");
        } catch (Exception any) {

            /**
             * Check to see if the sample table 'product' is created. If the
             * table does not exist, then create it.
             */
            try {
                System.out.println("We probably need to create the table 'product'. Error thrown was: " + any);
                stmt.executeUpdate("create table product (productID int PRIMARY KEY, name varchar, cost float)");
            } catch (Exception e2) {
            }
        } finally {
            try {
                stmt.close();
            } catch (Exception ee) {
            }
            try {
                conn.close();
            } catch (Exception ee) {
            }
        }
        try {
            conn = DriverManager.getConnection(DBurl);
            stmt = conn.createStatement();
            stmt.executeQuery("select * from inventory where productID=-1");
        } catch (Exception any) {
            /**
             * Check to see if the sample table 'inventory' is created. If the
             * table does not exist, then create it.
             */
            try {
                System.out.println("We probably need to create the table 'inventory'. Error thrown was: " + any);
                stmt.executeUpdate("create table inventory (productID int PRIMARY KEY, count int)");
            } catch (Exception e2) {
            }
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (Exception ee) {
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                } catch (Exception ee) {
                }
            }
        }

    }
}
