package S34;

import java.sql.*;

/**
 * User: markw
 * Date: Sep 13, 2003
 * Time: 10:36:23 AM
 */
public class JdbcInitialization {

    /**
     * Default constructor - applications that use this class should
     * create an instance - this will cause the JVM class loader to
     * load this class. During class loading, the static initialization
     * is performed.
     *
     * NOTE: if you set Java properties like:
     *
     *   System.setProperty("DBurl", "jdbc:postgresql://localhost:5432/db123?user=postgres");
     * you should do this before creating an instance of this class: this will
     * insure that the static code in this class is executed in an environment
     * where your Java properties have already been set.
     */
    public JdbcInitialization() {
    }

    public static String DBurl = "jdbc:postgresql://localhost:5432/db123?user=postgres";
    public static String DBdriver = "org.postgresql.Driver";

    static {
        /**
         * Check to see if parameters are set to override defaults:
         */
        try {
            DBurl = System.getProperty("DBurl", DBurl);
            DBdriver = System.getProperty("DBdriver", DBdriver);
        } catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Class.forName(DBdriver).newInstance();
        } catch (Exception e) {
            System.err.println("Could not open JDBC driver " +
                    DBdriver);
            e.printStackTrace();
        }
    }
}
