package S28;

import java.net.*;
import java.io.*;

public class ServerSocketThreadedDemo {

    // Default host name and port number:
    final static public String host = "127.0.0.1"; // local host
    final static public int port = 8000;
    final static public int maxConnectionQueueLength = 20;

    // inner class to handle socket input:


    public ServerSocketThreadedDemo() {
        ServerSocket serverSocket;
        try {
            serverSocket = new ServerSocket(port, maxConnectionQueueLength);
        } catch (IOException e) {
            System.out.println("Error in setting up server socket: " + e);
            return;
        }

        try {
            while (true) {
                Socket socket = serverSocket.accept();
                new HandleConnectionThread(socket);
            }
        } catch (IOException e) {
            System.out.println("Error in getting socket connection: " + e);
        } finally {
            try {
                serverSocket.close();
            } catch (IOException e) {
                System.out.println("I/O exception closing socket connection: " + e);
            }
        }
    }

    // an inner (inner) class to handle incoming socket connections
    class HandleConnectionThread extends Thread {
        protected transient Socket client_socket;
        protected transient BufferedReader input_strm;
        protected transient PrintStream output_strm;

        public HandleConnectionThread(Socket client_socket) {
            this.client_socket = client_socket;
            try {
                input_strm =
                        new BufferedReader(
                                new InputStreamReader(
                                        client_socket.getInputStream()));
                output_strm = new PrintStream(client_socket.getOutputStream());
            } catch (IOException io_exception) {
                try {
                    client_socket.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
                io_exception.printStackTrace();
                return;
            }
            // Start the thread (i.e., call method 'run'):
            this.start();
            //System.out.println("HandleConnectionThread is set up.");
        }

        public void run() {
            String input_buf;
            try {
                input_buf = input_strm.readLine();
                System.out.println("received on socket: " + input_buf);
                // modify string and return to client:
                output_strm.println(input_buf.toUpperCase());
                output_strm.flush();
                output_strm.close();
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                try {
                    client_socket.close();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }


    public static void main(String[] args) {
        new ServerSocketThreadedDemo();
    }
}
