package S28;

import java.net.*;
import java.io.*;

/**
 * <<edit description here>>
 * @author markw
 */
public class ServerSocketDemo {
    // Default host name and port number:
    final static public String host = "127.0.0.1"; // local host
    final static public int port = 8000;
    final static public int maxConnectionQueueLength = 20;

    public ServerSocketDemo() {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(port, maxConnectionQueueLength);
        } catch (IOException e) {
            e.printStackTrace();
            return; // error - server not started
        }
        Socket clientSocket = null;
        while (true) {
            try {
                try {
                    clientSocket = serverSocket.accept();
                } catch (IOException e) {
                    e.printStackTrace();
                    continue;    // wait for another client connection
                }

                PrintWriter out = new PrintWriter(clientSocket.getOutputStream(), true);
                BufferedReader in =
                        new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
                String input_buf = in.readLine();
                System.out.println("received on socket: " + input_buf);
                // return modified string to the client:
                out.println(input_buf.toUpperCase());
                out.close();
                in.close();
                clientSocket.close();
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                try {
                    clientSocket.close();
                } catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
    }
    public static void main(String[] args) throws Exception {
        new ServerSocketDemo();
    }
}
