package S27;

/**
 * User: markw
 * Date: Aug 18, 2003
 * Time: 7:52:39 AM
 */
public class ThreadGroupPriorityTest implements Runnable {
    public static void main(String[] args) {
        // create three thread groups: one with maximum priority and one with
        // medium priority, and one with low priority:
        ThreadGroup low = new ThreadGroup("low");
        ThreadGroup medium = new ThreadGroup("medium");
        ThreadGroup high = new ThreadGroup("high");
        low.setMaxPriority(Thread.MIN_PRIORITY);
        medium.setMaxPriority(Thread.NORM_PRIORITY);
        high.setMaxPriority(Thread.MAX_PRIORITY);
        // create three test threads:
        Thread lowThread = new Thread(low, new ThreadGroupPriorityTest("low"));
        Thread mediumThread = new Thread(medium, new ThreadGroupPriorityTest("medium"));
        Thread highThread = new Thread(high, new ThreadGroupPriorityTest("high"), "highPThread");
        // start the test threads:
        lowThread.start();
        mediumThread.start();
        highThread.start();
        // show threads in "main" thread group:
        ThreadGroup main = Thread.currentThread().getThreadGroup();
        int num = main.activeCount();
        System.out.println("Number of thread in group 'main'="+num);
        Thread[] threads = new Thread[num];
        main.enumerate(threads);
        System.out.print("Threads in thread group 'main':");
        for (int i=0; i<num; i++) {
            // note: do not use thread.getName() because some threads
            // may be null; use thread.toString() so a null thread
            // will print as "null":
            System.out.print(" " + threads[i]);   // use implicit toString()
        }
        System.out.println();
    }
    private String name;
    public ThreadGroupPriorityTest(String name) {
        this.name = name;
    }
    public void run() {
        // wait 1 second so the main method can print 'main' thread group information:
        try { Thread.sleep(1000L); } catch (Exception ee) { }
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        String tgName = tg.getName();
        String tgParent = tg.getParent().getName();
        for (int i=0; i<100; i++) {
            System.out.println(name + ": i = " + i+" thread group name="+tgName+", parent thread group name="+tgParent);
            //try { Thread.sleep(200L); } catch (Exception e) { }
        }
        // before exiting thread, print out all threads in current thread group:
        int num = tg.activeCount();
        Thread[] threads = new Thread[num];

        tg.enumerate(threads);
        System.out.print("Threads in thread group "+tgName+":");
        for (int i=0; i<num; i++) {
            System.out.print(" " + threads[i].getName());
        }
        System.out.println();
    }
}
