package S27;

/**
 * User: markw
 * Date: Aug 21, 2003
 * Time: 9:25:57 AM
 */
public class SecurityManagerDemo {
    public static void main(String[] args) {
        new SecurityManagerDemo();
    }

    public SecurityManagerDemo() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            Object securityContext = securityManager.getSecurityContext();
            System.out.println("securityContext=" + securityContext);
        } else {
            System.out.println("No security manager set.");
        }
        // install our demo security manager:
        System.setSecurityManager(new DemoSecurityManager());
        securityManager = System.getSecurityManager();
        if (securityManager != null) {
            Object securityContext = securityManager.getSecurityContext();
            System.out.println("securityContext=" + securityContext);
        } else {
            System.out.println("No security manager set.");
        }
        // test some featuires of custom security manager:
        try {
            System.exit(1);
        } catch (Exception e) {
            System.out.println("exit error: " + e);
        }
        try {
            ThreadGroup high = new ThreadGroup("high");
            high.setMaxPriority(Thread.MAX_PRIORITY);
        } catch (Exception e) {
            System.out.println("thread group modification error: " + e);
        }
    }

    class DemoSecurityManager extends SecurityManager {
        public void checkDelete(String fileName) throws SecurityException {
            // never allow file deletes:
            throw new SecurityException("Not allowed to delete file " + fileName);
        }
        public void checkConnect(String host, int port) throws SecurityException {
            // never allow remote socket connections:
            throw new SecurityException("Not allowed to connect to host" +
                    host + " port: " + port);
        }
        public void checkAccess(ThreadGroup tg) throws SecurityException {
            // never allow changing thread group parameters:
            throw new SecurityException("Not allowed modify thread group " + tg);
        }
        public void checkExit(int status) throws SecurityException {
            // never allow exiting the JVM:
            throw new SecurityException("Not to exit JVM with status=" + status);
        }
    }
}
