package S25;

import java.util.Timer;
import java.util.TimerTask;

/**
 * User: markw
 * Date: Aug 20, 2003
 * Time: 9:21:07 AM
 */
public class TimerDemo {
    Timer timer;


    public TimerDemo(int seconds) {
        timer = new Timer(true);
        timer.schedule(new MessageTask(), seconds*1000);
    }

    public TimerDemo(int wait_seconds, int seconds) {
        timer = new Timer();
        timer.schedule(new MessageTask(), wait_seconds*1000, seconds*1000);
    }

    class MessageTask extends TimerTask {
        private int max_prints = 3;
        private int count = 0;
        public void run() {
            System.out.println("TimerTask " + this + ", count="+count);
            if (count++ > max_prints)  timer.cancel();
        }
    }

    public static void main(String args[]) {
        System.out.println("Create two instances of TimerDemo...");
        new TimerDemo(2); // run task 1 time after waiting 2 seconds
        new TimerDemo(5, 1); // wait 5 seconds, then run task once every 1 second
        System.out.println("... threads started: wait for completion...");
    }
}
