package S24;

/**
 * User: markw
 * Date: Jul 27, 2003
 * Time: 1:19:25 PM
 */
public class QuickSort {
    public static final boolean DEBUG = true;

    public static void main(String[] args) {
        //float[] ff = {2, 1, 4, 7, 9, 11, 3, 200, 102, 5, 17, 12};
        float[] ff = {7, 3, 2, 1};
        QuickSort sort = new QuickSort(ff);
        float[] results = sort.getResults();
        for (int i = 0; i < results.length; i++) {
            System.out.println(" " + results[i]);
        }
    }

    QuickSort(float[] data) {
        this.results = data;    // the original data will be over written!!
        doQuickSort(0, data.length - 1);
    }

    public float[] getResults() {
        return results;
    }

    private float[] results;

    private void doQuickSort(int first, int last) {
        if (DEBUG) System.out.println("doQuickSort("+first+", "+last+")");
        if (first < last) {
            int partitionElementIndex = partition(first, last);
            doQuickSort(first, partitionElementIndex - 1);
            doQuickSort(partitionElementIndex + 1, last);
        }
    }

    /**
     * For results[first -> last], choose a partition element 'pe' and
     * move results so all elements in front of 'pe' are less than or equal
     * tp 'pe' and all elements after 'pe' are greater than or equal to 'pe'.
     * 'peIndex' is the index of 'pe.  Return 'peIndex'
     * @param firstIndex
     * @param lastIndex
     * @return
     */
    private int partition(int firstIndex, int lastIndex) {
        if (DEBUG) {
            System.out.print("  partition("+firstIndex+", "+lastIndex+") [");
            for (int k=firstIndex; k<=lastIndex; k++) System.out.print(" "+results[k]);
            System.out.print("] --> [");
        }
        float partitionElement = results[firstIndex];
        int partitionElementFinalIndex = firstIndex;
        // the following two indices will be used to find elements on either
        // side of partitionElement to swap:
        int swapLowIndex = firstIndex;
        int swapHighIndex = lastIndex;

        do	// loop over data[first -> last]
        {
            // start by finding an element 'above' partitionElement that is
            // less than partitionElement:
            while (swapHighIndex > swapLowIndex && results[swapHighIndex] >= partitionElement)
                swapHighIndex--;
            partitionElementFinalIndex = swapHighIndex;
            // now try to find a swapLowIndex to swap:
            if (swapHighIndex != swapLowIndex) {
                results[swapLowIndex] = results[swapHighIndex];
                while (swapHighIndex > swapLowIndex && results[swapLowIndex] <= partitionElement)
                    swapLowIndex++;
                partitionElementFinalIndex = swapLowIndex;
                if (swapHighIndex != swapLowIndex)
                    results[swapHighIndex] = results[swapLowIndex];
            }
        } while (swapHighIndex > swapLowIndex);
        results[partitionElementFinalIndex] = partitionElement;
        if (DEBUG) {
            for (int k=firstIndex; k<=lastIndex; k++) System.out.print(" "+results[k]);
            System.out.println("] pi=" + partitionElementFinalIndex);
        }
        return partitionElementFinalIndex;
    }
}