package S23;

/**
 * User: markw
 * Date: Jul 27, 2003
 * Time: 1:19:13 PM
 */
public class MergeSort {
    public static final boolean DEBUG = true;

    public static void main(String[] args) {
        //float[] ff = {2,1,4,7,9,11,3,200,102,5,17,12};
        float[] ff = {7, 3, 2, 1};
        MergeSort sort = new MergeSort(ff);
        float[] results = sort.getResults();
        for (int i=0; i<results.length; i++) {
            System.out.println(" " + results[i]);
        }
    }
    public MergeSort(float[] array) {
        results = new float[array.length];
        this.array = array;
        doMergeSort(0, array.length - 1);
    }
    private void doMergeSort(int start, int end) {
        if (DEBUG) System.out.println("doMergeSort("+start+", " + end+")");
        if (start < end) {
            int mid = (start + end) / 2;
            doMergeSort(start, mid);
            doMergeSort(mid + 1, end);
            doMerge(start, mid, end);
        }

    }
    public float[] getResults() {
        return  results;
    }

    private float[] results;
    private float[] array;

    private void doMerge(int start, int mid, int end) {
        if (DEBUG) {
            System.out.print("  doMerge("+start+", " + mid + ", " + end+") [");
            for (int k=start; k<=end; k++) System.out.print(" " + array[k]);
            System.out.print(" ] -->");
        }
        int i1 = start;
        int j1 = mid;
        int i2 = mid+1;
        int j2 = end;
        int i = start;
        while (i1 <= j1 && i2 <= j2) {
            if (array[i1] < array[i2]) {
                results[i] = array[i1];
                i1++;
            }else {
                results[i] = array[i2];
                i2++;
            }
            i++;
        }
        while (i1 <= j1) {
            results[i] = array[i1];
            i++;
            i1++;
        }
        while (i2 <= j2) {
            results[i] = array[i2];
            i++;
            i2++;
        }
        for (int k=start; k<=end; k++)  array[k] = results[k];
        if (DEBUG) {
            System.out.print(" [");
            for (int k=start; k<=end; k++) System.out.print(" " + results[k]);
            System.out.println(" ]");
        }
    }
}
