package S21;

import java.util.*;

import S20.NineSquares;
import S20.DepthFirstNoDuplicates;

/**
 *  Class for iterative deepening depth first search. This code is very different than
 * the code for the breadth first and the heuristic breadth first code.
 */
public class IterativeDeepening extends DepthFirstNoDuplicates {

    static public void main(String[] args) {
        IterativeDeepening p = new IterativeDeepening();
        //p.solve(new NineSquares("6173 4582"), new NineSquares("1238 4765"));
        //p.solve(new NineSquares("6173 4582"), new NineSquares("1234 5678"));
        p.solve(new NineSquares("21 364875"), new NineSquares("12345678 "));
        //p.solve(new NineSquares("6173 4582"), new NineSquares("617342508")); // trivial test
    }

    /**
     *  Main driver for deepening the search: loop on maximum allowable search depth.
     */
    public void solve(NineSquares start, NineSquares goal) {
        long time0 = System.currentTimeMillis();
        for (int maxDepth = 0; maxDepth < 200; maxDepth++) {
            avoidDuplicates = new Hashtable();
            long current = System.currentTimeMillis();
            long time = (current - time0) / 1000;
            System.out.println("Starting search for depth " + maxDepth + " at " + time + " seconds, # duplicates: " +
                               countDuplicates + ", # expanded nodes: " + countExpanded);
            solve(0, maxDepth, start, goal);
        }
    }
}

