package S20;

import java.util.*;

public class NineSquares {
    public int[] b = new int[9];

    public NineSquares(String state) {
        if (state.length() != 9) {
            System.out.println("Error in NineSquares(" + state + "): initial state string must be 9 characters long.");
            System.exit(1);
        }
        for (int i = 0; i < 9; i++) {
            char ch = state.charAt(i);
            if (ch == ' ') {
                b[i] = 0;
            } else {
                b[i] = (int) (ch - '0');
            }
        }
    }

    public NineSquares() {
    }

    private char[] ch = new char[9];

    public String toString() {
        for (int i = 0; i < 9; i++) ch[i] = (char) ('0' + b[i]);
        return new String(ch);
    }

    public boolean equals(NineSquares b2) {
        for (int i = 0; i < 9; i++) {
            if (b[i] != b2.b[i]) return false;
        }
        return true;
    }
    /**
     *  Utility for making a move given a board position and the index of a piece to move
     */
    public static NineSquares makeMove(NineSquares b, int move) {
        NineSquares b2 = new NineSquares();
        int blankIndex = 0;
        for (int i = 0; i < 9; i++) {
            b2.b[i] = b.b[i];
            if (b.b[i] == 0) blankIndex = i;
        }
        b2.b[blankIndex] = b2.b[move];
        b2.b[move] = 0;
        return b2;
    }
    public Vector possibleMoves() {
        Vector v = new Vector();
        int index = 0;
        for (int i = 0; i < 9; i++) {
            if (b[i] == 0) {
                index = i;
                break;
            }
        }
        switch (index) {
            case 0:
                v.add(new Integer(1));
                v.add(new Integer(3));
                break;
            case 1:
                v.add(new Integer(0));
                v.add(new Integer(4));
                v.add(new Integer(2));
                break;
            case 2:
                v.add(new Integer(1));
                v.add(new Integer(5));
                break;
            case 3:
                v.add(new Integer(0));
                v.add(new Integer(4));
                v.add(new Integer(6));
                break;
            case 4:
                v.add(new Integer(1));
                v.add(new Integer(3));
                v.add(new Integer(5));
                v.add(new Integer(7));
                break;
            case 5:
                v.add(new Integer(2));
                v.add(new Integer(4));
                v.add(new Integer(8));
                break;
            case 6:
                v.add(new Integer(3));
                v.add(new Integer(7));
                break;
            case 7:
                v.add(new Integer(4));
                v.add(new Integer(6));
                v.add(new Integer(8));
                break;
            case 8:
                v.add(new Integer(5));
                v.add(new Integer(7));
                break;
        }
        return v;
    }
}

