package S20;

import java.util.*;

/**
 *  Class for iterative deepening depth first search. This code is very different than
 * the code for the breadth first and the heuristic breadth first code.
 */
public class DepthFirstNoDuplicates {

    static public int DEBUG = 0;  // 0=no debug, 1=little debug, 2=lots of debug
    protected int countExpanded = 0;
    protected int [] moveList = new int[200];
    protected Hashtable avoidDuplicates = null;
    protected int countDuplicates = 0;

    static public void main(String[] args) {
        DepthFirstNoDuplicates p = new DepthFirstNoDuplicates();
        p.solve(new NineSquares("6173 4582"), new NineSquares("1238 4765"));
        //p.solve(new NineSquares("6173 4582"), new NineSquares("617342508")); // trivial test
    }

    /**
     *  Main driver for deepening the search: loop on maximum allowable search depth.
     */
    public void solve(NineSquares start, NineSquares goal) {
        long time0 = System.currentTimeMillis();
        avoidDuplicates = new Hashtable();
        solve(0, 100, start, goal);
    }

    /**
     *  Lower level search driver - this method calls itself recursively
     */
    public void solve(int depth, int maxDepth, NineSquares start, NineSquares goal) {
        if (depth > maxDepth) return;
        String s2 = start.toString();
        if (avoidDuplicates.get(s2) != null) {
            countDuplicates++;
            return; // already looked at this position, so skip it
        }
        avoidDuplicates.put(s2, new Boolean(true));
        countExpanded++;
        if (start.equals(goal)) {
            System.out.println("Found a solution at depth " + depth + ":");
            for (int i = 0; i < depth; i++) {
                System.out.print(" " + moveList[i]);
            }
            System.out.println("\nNumber of nodes expanded="+countExpanded);
            System.out.println("\tNumber of duplicate nodes="+countDuplicates);
            System.exit(0);
        }
        Vector possibleMoves = start.possibleMoves();
        for (int i = 0, size = possibleMoves.size(); i < size; i++) {
            int move = ((Integer) possibleMoves.elementAt(i)).intValue();
            NineSquares newBoard = NineSquares.makeMove(start, move);
            //System.out.println("new board: " + newBoard.asString());
            moveList[depth] = move;
            countExpanded++;
            solve(depth + 1, maxDepth, newBoard, goal);
        }
    }
}
