package S20;

import java.util.*;

/**
 *  Class for iterative deepening depth first search. This code is very different than
 * the code for the breadth first and the heuristic breadth first code.
 */
public class DepthFirst {

    static public int DEBUG = 0;  // 0=no debug, 1=little debug, 2=lots of debug
    int countExpanded = 0;
    int [] moveList = new int[200];

    static public void main(String[] args) {
        DepthFirst p = new DepthFirst();
        p.solve(new NineSquares("6173 4582"), new NineSquares("1238 4765"));
        //p.solve(new NineSquares("6173 4582"), new NineSquares("617342508")); // trivial test
    }

    /**
     *  Main driver for deepening the search: loop on maximum allowable search depth.
     */
    public void solve(NineSquares start, NineSquares goal) {
        solve(0, 20, start, goal);
    }

    /**
     *  Lower level search driver - this method calls itself recursively
     */
    public void solve(int depth, int maxDepth, NineSquares current, NineSquares goal) {
        if (depth > maxDepth) return;
        String s2 = current.toString();
        if (current.equals(goal)) {
            System.out.println("Found a solution at depth " + depth + ":");
            for (int i = 0; i < depth; i++) {
                System.out.print(" " + moveList[i]);
            }
            System.out.println("\nNumber of nodes expanded="+countExpanded);
            System.exit(0);
        }
        Vector possibleMoves = current.possibleMoves();
        for (int i = 0, size = possibleMoves.size(); i < size; i++) {
            int move = ((Integer) possibleMoves.elementAt(i)).intValue();
            NineSquares newBoard = NineSquares.makeMove(current, move);
            //System.out.println("new board: " + newBoard.asString());
            moveList[depth] = move;
            countExpanded++;
            solve(depth + 1, maxDepth, newBoard, goal);
        }
    }
}
