package S18;

import java.util.Hashtable;
import java.io.ObjectOutputStream;
import java.io.ByteArrayOutputStream;

/**
 * User: markw
 * Date: Jul 18, 2003
 * Time: 3:08:05 PM
 */
public class TestIntHash {
    public static void main(String[] args) throws Exception {
        StringIntHashtable test = new StringIntHashtable(2, 10);
        test.put("one", 1);
        test.put("one", 1);
        test.put("twenty", 20);
        test.put("twenty", 20);
        test.put("twenty", 20);
        test.put("million", 1000000);
        test.put("thousand_and_one", 1001);
        test.put("thousand_and_one", 1001);
        test.put("thousand_and_one", 1001);
        test.put("thirty three", 33);
        test.put("four hundred", 400);
        test.put("four hundred", 400);
        test.put("four hundred", 400);

        check("one", test);
        check("twenty", test);
        check("million", test);
        check("thousand_and_one", test);
        check("thirty three", test);
        check("four hundred", test);
        check("a key not in hash table", test);

        test.debug();

        System.out.println("\n******** start final hash table test:\n");
        StringIntHashtableFinal fHash = test.toFinal();

        checkFinal("one", fHash);
        checkFinal("twenty", fHash);
        checkFinal("million", fHash);
        checkFinal("thousand_and_one", fHash);
        checkFinal("thirty three", fHash);
        checkFinal("four hundred", fHash);
        checkFinal("a key not in hash table", fHash);

        System.out.println("\n******** start benchmark test:\n");

        int testSize = 20000;

        StringIntHashtable test2 = new StringIntHashtable(10, 10); // testSize / 40);
        Hashtable testHash = new Hashtable();
        String[] ks = new String[testSize];
        int[] kv = new int[testSize];

        printMemory("before Java hash creation");
        for (int i = 0; i < testSize; i++) {
            kv[i] = (int) (Math.random() * 221231);
            ks[i] = "" + kv[i];
            testHash.put(ks[i], ks[i]);
        }
        printMemory("after Java hash creation");
        printMemory("before StringIntHashtable hash creation");

        for (int i = 0; i < testSize; i++) {
            kv[i] = (int) (Math.random() * 221231);
            ks[i] = "" + kv[i];
            test2.put(ks[i], kv[i]);
            testHash.put(ks[i], ks[i]);
        }
        printMemory("after StringIntHashtable hash creation");
        printMemory("before final hash creation");
        StringIntHashtableFinal finalHash = test2.toFinal();
        printMemory("after final hash creation");

        long time1 = System.currentTimeMillis();
        for (int i = 0; i < testSize; i++) {
            int ii = finalHash.get(ks[i]);
        }
        long time2 = System.currentTimeMillis();
        for (int i = 0; i < testSize; i++) {
            Object oo = testHash.get(ks[i]);
        }
        long time3 = System.currentTimeMillis();
        System.out.println("time for final int hash: " + (time2 - time1));
        System.out.println("time for Java util hash: " + (time3 - time2));

        int size1 = estimateObjectSize(testHash, "java.util.Hashtable");
        estimateObjectSize(test2, "StringIntHashtable");
        int size2 = estimateObjectSize(finalHash, "StringIntHashtableFinal");
        float savings = (float)(size1 - size2)/(float)size2;
        System.out.println(" memory savings="+savings);

        String the = "the";
        the.intern();
        String temp = "the";
        if (the == temp) System.out.println("same string instance");


    }

    private static void check(String key, StringIntHashtable test) {
        int value = test.get(key);
        System.out.println(" key: " + key + "   value: " + value);
    }

    private static void checkFinal(String key, StringIntHashtableFinal test) {
        int value = test.get(key);
        System.out.println(" key: " + key + "   value: " + value);
    }

    private static void printMemory(String message) {
        System.gc();
        Runtime runtime = Runtime.getRuntime();
        long freeMemory = runtime.freeMemory();
        long maxMemory = runtime.maxMemory();
        long totalMemory = runtime.totalMemory();
        System.out.println("\nMemory ("+message+") use: free="+freeMemory+", max="+maxMemory+", total="+totalMemory);
    }
    private static int estimateObjectSize(Object obj, String name) throws Exception {
        ByteArrayOutputStream byteOuptutStream = new ByteArrayOutputStream();
        ObjectOutputStream objectStream = new ObjectOutputStream(byteOuptutStream);
        objectStream.writeObject(obj);
        objectStream.flush();
        byte[] bytes = byteOuptutStream.toByteArray();
        int len = bytes.length;
        System.out.println(" Size of " + name + " is approximately " + len + " bytes.");
        return len;
    }
}
