package S18;

import java.io.Serializable;
import java.util.Arrays;

/**
 * User: markw
 * Date: Jul 19, 2003
 * Time: 3:17:56 PM
 */
public class StringIntHashtableFinal implements Serializable {

    // package access only so StringIntHashtable has access for construction:
    String[][] binKeys;
    int[][] binValues;
    int numBins;

    // no public constructor: instance creation only by StringIntHashtable class
    StringIntHashtableFinal() {
    }

    // no put method: this hash table is FINAL!

    public int get(String key) {
        int binIndex = hashFunction(key);
        // do a fast binary search:
        int index = Arrays.binarySearch(binKeys[binIndex], key);
        if (index == -1) return NO_VAL;
        return binValues[binIndex][index];
    }

    public static final int NO_VAL = -918121723;

    private final int hashFunction(String s) {
        long num = 0;
        int size = s.length();
        for (int i = 0; i < size; i++) {
            num += i * (int) s.charAt(i);
        }
        return (int) (num % numBins);
    }


}
