package S18;

import java.util.ArrayList;
import java.io.Serializable;

/**
 * User: markw
 * Date: Jul 18, 2003
 * Time: 3:07:53 PM
 */
public class StringIntHashtable implements Serializable {
    public static final int NO_VAL = -918121723;

    public StringIntHashtable() {
        this(50, 10);
    }

    public StringIntHashtable(int numBins, int initialBinSize) {
        this.numBins = numBins;
        this.initialBinSize = initialBinSize;
        this.entries = new ArrayList[numBins];
        for (int i = 0; i < numBins; i++) {
            entries[i] = new ArrayList(initialBinSize);
        }
    }
   public void debug() {
       System.out.println("\nStringIntHashtable: numBins="+numBins+", initialBinSize="+initialBinSize);
       for (int i=0; i<numBins; i++) {
           System.out.println("  bin # " + i);
           ArrayList al = entries[i];
           for (int j=0, size=al.size(); j<size; j++) {
               System.out.println("    " + al.get(j));
           }
       }
   }
    public final int get(String key) {
        int binIndex = hashFunction(key);
        ArrayList al = entries[binIndex];
        // do a fast binary search:
        int index = searchIndex(al, key);
        if (index == -1)  return NO_VAL;
        HashEntry he = (HashEntry)al.get(index);
        return he.getValue();
    }


    private final int searchIndex(ArrayList array, String target) {
        int lowIndex = -1;
        int highIndex = array.size();
        while (highIndex - lowIndex > 1) {
            int middleIndex = (highIndex + lowIndex) / 2;
            HashEntry he = (HashEntry) array.get(middleIndex);
            if (he.getKey().compareTo(target) > 0) {
                highIndex = middleIndex;
            } else {
                lowIndex = middleIndex;
            }
        }
        if (lowIndex == -1) return -1;
        HashEntry low = (HashEntry) array.get(lowIndex);
        if (low.getKey().equals(target) == false) return -1;
        return lowIndex;
    }

    public int put(String key, int value) {
        int binIndex = hashFunction(key);
        ArrayList al = entries[binIndex];
        // insert a new HashEntry into the array list in sorted order:
        HashEntry he = new HashEntry(key, value);
        int size = al.size();
        int index = searchIndex(al, key);
        if (index != -1) return value; // already in hash table
        HashEntry h1;
        //HashEntry h2 = (HashEntry) al.get(0);
        for (int i = 0; i < size; i++) {
            h1 = (HashEntry) al.get(i);
            //h2 = (HashEntry) al.get(i);
            if (h1.getKey().compareTo(key) == 0) return value; // already in hash table
            //if (h2.getKey().compareTo(key) == 0) return value; // already in hash table
            if (h1.getKey().compareTo(key) > 0) {
                // shift all values up in array list:
                al.add(null);
                for (int j = (size - 1); j >= i; j--) {
                    al.set(j+1, al.get(j));
                }
                al.set(i, he);
                return value;
            }
        }
        // not inserted: add to end:
        al.add(he);
        return value;
    }

    private final int hashFunction(String s) {
        long num = 0;
        int size = s.length();
        for (int i = 0; i < size; i++) {
            num += i * (int) s.charAt(i);
        }
        return (int) (num % numBins);
    }


    //      Publish to a StringIntHashtableFinal FINAL hash table instance:

    public StringIntHashtableFinal toFinal() {
        StringIntHashtableFinal ret = new StringIntHashtableFinal();
        ret.binKeys = new String[numBins][];
        ret.binValues = new int[numBins][];
        ret.numBins = numBins;
        for (int i=0; i<numBins; i++) {
            ArrayList al = entries[i];
            int size = al.size();
            ret.binKeys[i] = new String[size];
            ret.binValues[i] = new int[size];
            for (int j=0; j<size; j++) {
                HashEntry he = (HashEntry)al.get(j);
                ret.binKeys[i][j] = he.getKey();
                ret.binValues[i][j] = he.getValue();
            }
        }
        return ret;
    }

    private int numBins;
    private int initialBinSize;
    private ArrayList[] entries;

    class HashEntry implements Serializable {
        public HashEntry(String key, int value) {
            this.key = key;
            this.value = value;

        }
        public String toString() {
            return "[HashEntry: " + key + " : " + value + "]";
        }
        private String key;
        private int value;

        public String getKey() {
            return key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public int getValue() {
            return value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }
}
