package S14;

import java.io.*;
import java.util.*;
import java.net.*;

// Utility class to manage socket connections:

public class ServerConnection extends Thread {
    protected transient Socket my_socket;
    protected transient BufferedInputStream input_strm;
    protected transient PrintStream output_strm;
    protected transient AbstractServer myServer;

    public ServerConnection(AbstractServer server,
                            Socket client_socket) {
        myServer = server;
        my_socket = client_socket;
        try {
            input_strm = new BufferedInputStream(my_socket.getInputStream());
            output_strm = new PrintStream(my_socket.getOutputStream());
            my_socket.setSoTimeout(3000);  // a short 3 second timeout
            my_socket.setTcpNoDelay(true);
        } catch (IOException io_exception) {
            try {
                my_socket.close();
            } catch (IOException io_ex2) {
            }
            ;
            System.err.println("Exception: getting socket streams " +
                    io_exception);
            return;
        }
        // Start the thread (i.e., call method 'run'):
        this.start();
        //System.out.println("ServerConnection is set up.");
    }

    public void run() {
        String input_buf;
        byte[] buf = new byte[1024];
        try {
            while (true) {
                int num = input_strm.read(buf);
                if (num == 0) break;
                input_buf = new String(buf, 0, num);
                //System.out.println("web browser request: " + input_buf);
                if (input_buf.indexOf("GET") > -1) {
                    myServer.process(input_buf, output_strm);
                }
            }
        } catch (Exception exception) {
        } finally {
            try {
                my_socket.close();
            } catch (Exception exception) {
            }
        }
    }
}
