package S14;

import java.io.*;
import java.util.*;
import java.net.*;

/**
 *    test with:  http://127.0.0.1:8080/?foo&a=1&b=2
 *
 */
abstract public class AbstractServer {
    abstract public String getXmlPayload(String functionName,
                                         String[] argumentNames,
                                         String[] argumentValues);

    protected int port = 8080;

    //protected String defaultMailHost, defaultRecipient, defaultDomain;

    public AbstractServer() {
        run();
    }

    // Callback from ServerConnection class:
    public void process(String command, PrintStream output_strm) {
        //System.err.println("process command: " + command);
        // Check for a "GET /"
        int index;
        int index0 = command.indexOf("GET ");
        if (index0 > -1) {
            index = command.indexOf("/?", index0 + 2);
            if (index > 0) {
                int index8 = command.indexOf("&", index+1);
                String function = command.substring(index+2, index8);
                System.out.println("function=|"+function+"|");
                //System.out.println("AbstractServer.process(" + command + ")");
                command = command.substring(index + 1);
                int index10 = command.indexOf(" HTTP/");
                if (index10 > -1) {
                    command = command.substring(0, index10);
                }
                if (command.endsWith(";")) command = command.substring(0, command.length() - 1);
                System.out.println("modified command: " + command);

                String[] variables = new String[20];
                String[] values = new String[20];
                int numVariables = 0;

                while (true) {
                    int index20 = command.indexOf("&");
                    //System.out.println("index20=" + index20);
                    if (index20 == -1) {
                        int index2 = command.indexOf("=");
                        if (index2 > -1) {
                            variables[numVariables] = fixSpaces(command.substring(0, index2));
                            values[numVariables] = fixSpaces(command.substring(index2 + 1));
                            numVariables++;
                        }
                        break;
                    }
                    String com = command.substring(0, index20);
                    command = command.substring(index20 + 1);
                    int index3 = com.indexOf("=");
                    if (index3 > -1) {
                        variables[numVariables] = fixSpaces(com.substring(0, index3));
                        values[numVariables] = fixSpaces(com.substring(index3 + 1));
                        numVariables++;
                    }
                }
                String[] names = new String[numVariables];
                String[] vals = new String[numVariables];
                for (int i = 0; i < numVariables; i++) {
                    names[i] = variables[i];
                    vals[i] = values[i];
                }
                String xml = getXmlPayload(function, names, vals);
                output_strm.print(xml);
                output_strm.print("\n");
                output_strm.flush();
                output_strm.close();
                return;
            }
        }
        output_strm.flush();
        output_strm.close();
        return;
    }

    private String fixSpaces(String s0) {
        StringBuffer sb = new StringBuffer();
        String s = s0.replace('+', ' ') + "   ";
        int index = 0;
        while (true) {
            index = s.indexOf("%");
            if (index == -1) {
                sb.append(s);
                return sb.toString().trim();
            }
            sb.append(s.substring(0, index));
            String keyCode = s.substring(index, index + 3);
            String cc = null;
            if (keyCode.equalsIgnoreCase("%26"))
                cc = "&";
            else if (keyCode.equalsIgnoreCase("%3B"))
                cc = ";";
            else if (keyCode.equalsIgnoreCase("%25"))
                cc = "%";
            else if (keyCode.equalsIgnoreCase("%21"))
                cc = "!";
            else if (keyCode.equalsIgnoreCase("%23"))
                cc = "#";
            else if (keyCode.equalsIgnoreCase("%24"))
                cc = "$";
            else if (keyCode.equalsIgnoreCase("%5E"))
                cc = "^";
            else if (keyCode.equalsIgnoreCase("%28"))
                cc = "(";
            else if (keyCode.equalsIgnoreCase("%29"))
                cc = ")";
            else if (keyCode.equalsIgnoreCase("%2B"))
                cc = "+";
            else if (keyCode.equalsIgnoreCase("%3A"))
                cc = ":";
            else if (keyCode.equalsIgnoreCase("%3B"))
                cc = ";";
            else if (keyCode.equalsIgnoreCase("%27"))
                cc = "'";
            else if (keyCode.equalsIgnoreCase("%22"))
                cc = "\"";
            else if (keyCode.equalsIgnoreCase("%2C"))
                cc = ",";
            else if (keyCode.equalsIgnoreCase("%2F"))
                cc = "/";
            else if (keyCode.equalsIgnoreCase("%3F"))
                cc = "?";
            else if (keyCode.equalsIgnoreCase("%5C"))
                cc = "\\";
            else if (keyCode.equalsIgnoreCase("%7C"))
                cc = "|";
            else if (keyCode.equalsIgnoreCase("%7B"))
                cc = "{";
            else if (keyCode.equalsIgnoreCase("%7D"))
                cc = "}";
            else if (keyCode.equalsIgnoreCase("%5B"))
                cc = "[";
            else if (keyCode.equalsIgnoreCase("%5D"))
                cc = "]";
            else if (keyCode.equalsIgnoreCase("%0D"))
                cc = " ";
            else if (keyCode.equalsIgnoreCase("%0A")) cc = "";
            if (cc != null) {
                sb.append(cc);
                s = s.substring(index + 3);
            } else {
                sb.append(s.substring(index, index + 1));
                s = s.substring(index + 1);
            }
        }
    }

    public void run() {
        ServerSocket serverSocket;
        try {
            serverSocket = new ServerSocket(port, 2000);
        } catch (IOException e) {
            System.out.println("AbstractServer: " + e);
            return;
        }

        try {
            while (true) {
                Socket socket = serverSocket.accept();
                new ServerConnection(this, socket);
            }
        } catch (IOException e) {
            System.out.println("Error: new socket connection: " + e);
        } finally {
            try {
                serverSocket.close();
            } catch (IOException e) {
                System.out.println("I/O exception: " + e);
            }
        }
    }
}
