package S13;

import java.util.*;
import java.io.*;

import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.WebServer;
import org.apache.xmlrpc.XmlRpcHandler;


public class ExampleXmlRpcServer {
    public ExampleXmlRpcServer() {
    }

    public static void main(String[] args) {
        try {
            //XmlRpc.setKeepAlive(true);
            WebServer s = new WebServer(8100);
            s.addHandler("$default", new ExampleXmlRpcHandler());
            s.setParanoid(true);
            // deny all clients
            s.acceptClient("127.0.0.1"); // allow local access
            s.start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}

class ExampleXmlRpcHandler implements XmlRpcHandler {
    public Object execute(String method, Vector v) throws Exception {
        System.out.println("ExampleXmlRpcHandler.execute: method name=" + method);
        if (method.equals("testMethod")) {
            return testMethod(v);
        }
        System.out.println("ExampleXmlRpcServer error: unknown method name: " + method);
        return null;  // error: unknown method name
    }

    Vector testMethod(Vector v) {
        System.out.println("entered testMethod("+v+")");
        Vector ret = new Vector();
        // get the example arguments:
        String s = (String)v.get(0);
        Double f = (Double)v.get(1);
        Integer i = (Integer)v.get(2);
        ret.add(s + s);
        ret.add(new Float(2 * f.floatValue()));
        ret.add(new Integer(2 * i.intValue()));
        return ret;
    }
}
