package S12;

import java.io.File;
import java.io.FileOutputStream;
import java.util.List;
import java.util.Iterator;

import S12.zeus_generated.*;

public class ZeusTest {
    public static void main(String[] args) {
        try {
            // unmarshalling from the XML file S12/company.xml:
            boolean xmlValidation = false;
            Company company = CompanyUnmarshaller.unmarshal(new File("S12/company.xml"), xmlValidation);
            String companyName = company.getName();
            List employees = company.getEmployeeList();
            System.out.println("Company name: " + companyName);
            for (Iterator iter = employees.iterator();
                 iter.hasNext();) {
                Employee employee = (Employee)iter.next();
                String last_name = employee.getLast_name();
                String first_name = employee.getFirst_name();
                System.out.println("  employee: " + first_name + " " + last_name);
            }
            // add a new employee:
            Employee employee3 = new EmployeeImpl();
            employee3.setFirst_name("John Paul");
            employee3.setLast_name("Sartre");
            company.addEmployee(employee3);
            // Marshal to a new XML file S12/company2.xml:
            company.marshal(new FileOutputStream(new File("S12/company2.xml")));

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
