package S12;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.util.ValidationEventCollector;

import S12.jaxb_generated.*;
import S12.jaxb_generated.impl.EmployeeImpl;
import S12.jaxb_generated.impl.EmployeeTypeImpl;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.File;
import java.util.List;
import java.util.Iterator;

public class TestJAXB {
    public static void main(String[] args) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance("S12.jaxb_generated");
        Unmarshaller unMarshaller = jaxbContext.createUnmarshaller();
        unMarshaller.setValidating(false);
        Company company =
                (Company) unMarshaller.unmarshal(new FileInputStream("S12/company.xml"));
        String companyName = company.getName();
        List employees = company.getEmployee();
        System.out.println("Company name: " + companyName);
        for (Iterator iter = employees.iterator();
             iter.hasNext();) {
            EmployeeType employee = (EmployeeType)iter.next();
            String last_name = employee.getLastName();
            String first_name = employee.getFirstName();
            System.out.println("  employee: " + first_name + " " + last_name);
        }
        // add an employee:
        //EmployeeType employee3 = new EmployeeImpl();
        EmployeeTypeImpl employee3 = new EmployeeTypeImpl();
        employee3.setFirstName("John Paul");
        employee3.setLastName("Sartre");
        employee3.setValue("");
        employees.add(employee3);

        // write out a new XML file with the new employee element added:
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);
        marshaller.marshal(company, new FileOutputStream(new File("S12/company3.xml")));
    }
}
