package S11;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;

import org.dom4j.Document;
import org.dom4j.io.*;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class TestXSLT {

    public static void main(String[] args) throws Exception {
        TestXSLT test = new TestXSLT("S11/xslt.xml");
        SAXReader reader = new SAXReader();
        Document document = reader.read("S11/test.xml");
        Document doc = test.transform(document);
        // now, write out the DOM for the generated XHTML to a new file:
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter(new FileWriter("S11/xslt_output.xml"), format);
            writer.write(doc);
            writer.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public TestXSLT(String xsltFile)
            throws javax.xml.transform.TransformerConfigurationException,
            java.io.FileNotFoundException {
        StreamSource xslt = new StreamSource(new FileReader(xsltFile));
        TransformerFactory factory = TransformerFactory.newInstance();
        xsltTransform = factory.newTransformer(xslt);
    }

    public Document transform(Document doc) throws javax.xml.transform.TransformerException {
        DocumentSource source = new DocumentSource(doc);
        DocumentResult result = new DocumentResult();
        xsltTransform.transform(source, result);
        return result.getDocument();
    }

    private Transformer xsltTransform;
}
