package S10;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.InputSource;

import java.util.ArrayList;
import java.io.StringReader;
import java.io.FileReader;

import javax.xml.parsers.SAXParserFactory;
import javax.xml.parsers.SAXParser;

public class TestSAX {
    public static void main(String[] args) {
        TestSAX test = TestSAX.fromXML("S10/test.xml");
        System.out.println("From test.xml: name="+test.name+", weight="+
                test.weight+", hobbies are:");
        for (int i=0, size=test.hobbies.size(); i<size; i++) {
            System.out.println("    " + test.hobbies.get(i));
        }
        String s = test.toXML();
        System.out.println("\nTest object to XML:\n"+s);
    }
    // define some local data for demonstrating serialization
    // to and from XML:
    private String name = "";
    private int weight;
    private ArrayList hobbies = new ArrayList(); // store strings

    public String toXML() {
        StringBuffer sb = new StringBuffer("<TestSAX name=\"" + name + "\" weight=\"" + weight + "\">\n");
        for (int i = 0, size = hobbies.size(); i < size; i++) {
            sb.append("  <hobby>" + hobbies.get(i) + "</hobby>\n");
        }
        sb.append("</TestXML>\n");
        return sb.toString();
    }

    static public TestSAX fromXML(String xmlInputFile) {
        try {
            TestSAX s = new TestSAX();
            SAXParserFactory f = SAXParserFactory.newInstance();
            f.setNamespaceAware(true);
            SAXParser p = f.newSAXParser();
            InputSource is = new InputSource(new FileReader(xmlInputFile));
            p.parse(is, new TestSAXHandler(s));
            return s;
        } catch (Exception e) {
            e.printStackTrace();
        }

        return null;
    }

    static class TestSAXHandler extends org.xml.sax.helpers.DefaultHandler {
        public TestSAXHandler(TestSAX parent) {
            this.parent = parent;
        }

        private TestSAX parent;
        private String lastElementName = "";

        public void startElement(String uri, String localName,
                                 String qName, Attributes attributes)
                throws SAXException {
            System.out.println("uri="+uri+", localName="+localName+", qName="+qName+"...)");
            lastElementName = qName;
            if (qName.equals("TestSAX")) {
                String w = attributes.getValue("weight");
                try {
                    parent.setWeight(Integer.parseInt(w));
                } catch (Exception ee) {
                }
                parent.setName(attributes.getValue("name"));
            }
        }

        public void characters(char ch[], int start, int length)
                throws SAXException {
            if (lastElementName.equals("hobby")) {
                String s = new String(ch, start, length).trim();
                if (s.length() > 0) {
                    parent.addHobby(s);
                }
            }
        }
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getWeight() {
        return weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public void addHobby(String hobby) {
        hobbies.add(hobby);
    }

    public ArrayList getHobbies() {
        return (ArrayList) hobbies.clone();
    }
}
