package S10;

import java.io.FileReader;
import javax.xml.parsers.*;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.InputSource;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

/**
 * This class is not application specific!  It reads an XML file and
 * and stores element data in an ArrayList containing:
 *
 *   0) element name
 *   1) character data (or null if none)
 *   2) Hashtable containing attribute names/values (or null if no attributes)
 *
 * Note, this class is not intended for highly structured data: only
 * top level elements contained in the single document root element are processed.
 */
public class ConfigFile {

    public static void main(String[] args) throws Exception {
        ConfigFile config = new ConfigFile("S10/config.xml");
        int num = config.getNumberOfElements();
        for (int i=0; i<num; i++) {
            String elementName = config.getElementName(i);
            String characterData = config.getCharacterData(i);
            Hashtable h = config.getAttributes(i);
            System.out.println("element: " + elementName);
            System.out.println("    character data: " + characterData);
            if (h != null) {
                for (Iterator iter=h.keySet().iterator();
                        iter.hasNext(); ) {
                    String key = (String)iter.next();
                    String value = (String)h.get(key);
                    System.out.println("      attribute name: " + key + ", value: " + value);
                }
            }
        }
    }

    private ArrayList allElements = new ArrayList();

    public int getNumberOfElements() {
        return allElements.size();
    }

    public String getElementName(int index) {
        ArrayList al = (ArrayList) allElements.get(index);
        return (String) al.get(0);
    }

    public String getCharacterData(int index) {
        ArrayList al = (ArrayList) allElements.get(index);
        return (String) al.get(1);
    }

    public Hashtable getAttributes(int index) {
        ArrayList al = (ArrayList) allElements.get(index);
        return (Hashtable) al.get(2);
    }

    public ConfigFile(String xmlPath) {
        try {
            SAXParserFactory f = SAXParserFactory.newInstance();
            f.setNamespaceAware(true);
            SAXParser p = f.newSAXParser();
            InputSource is = new InputSource(new FileReader(xmlPath));
            p.parse(is, new ConfigFileSaxHandler(this));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    class ConfigFileSaxHandler extends org.xml.sax.helpers.DefaultHandler {

        public ConfigFileSaxHandler(ConfigFile parent) {
            this.parent = parent;
        }

        private ConfigFile parent = null;
        private int depth = 0;
        private String currentElementName = "";
        private Hashtable currentAttributes = null;
        private String characterData = "";

        // override default methods for a few SAX events:
        public void startElement(String uri, String localName,
                                 String qName, Attributes attributes)
                throws SAXException {
            //System.out.println("start element: " + qName);
            depth++;
            System.out.println(" start element; depth=" + depth);
            if (depth > 2) {
                System.err.println("Error: input XML file has too deeply nested elements.");
                System.err.println("       elementName=" + qName + ", element depth=" + depth);
                return;
            }
            currentElementName = qName;
            if (attributes.getLength() < 1) {
                currentAttributes = null;
            } else {
                currentAttributes = new Hashtable();
                for (int i = 0, size = attributes.getLength(); i < size; i++) {
                    currentAttributes.put(attributes.getLocalName(i), attributes.getValue(i));
                }
            }
        }

        public void endElement(String uri, String localName, String qName)
                throws SAXException {
            depth--;
            System.out.println(" end element; depth=" + depth);
            if (depth != 1) return;
            ArrayList al = new ArrayList();
            al.add(currentElementName);
            al.add(characterData);
            al.add(currentAttributes);
            parent.allElements.add(al);
        }

        public void characters(char ch[], int start, int length)
                throws SAXException {
            String s = (new String(ch, start, length)).trim();
            if (s.length() < 1) return;
            characterData = s;
        }
    }
}
