package S09;

import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.Attribute;

import java.util.List;

import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.dom4j.io.OutputFormat;

import java.util.Iterator;
import java.io.FileWriter;
import java.io.IOException;

// Note: this code is partially derived from the "Quick Start"
//       guide to dom4j


public class TestDOM {

    public static void main(String[] args) throws DocumentException {
        TestDOM test = new TestDOM();
        Document document = test.parse("S09/test.xml");
        test.searchTree(document.getRootElement(), 0);
        // iterate through child elements of root
        for (Iterator iter = document.getRootElement().elementIterator();
             iter.hasNext();) {
            Element element = (Element) iter.next();
            System.out.println("Child node demo: element=" + element);
        }
        // demonstrate using XPATH:
        List list = document.selectNodes("//company/employee");
        for (Iterator iter = list.iterator();
             iter.hasNext();) {
            Element element = (Element) iter.next();
            System.out.println("XPATH demo: element=" + element);
        }
        // searching for a specific attribute values:
        list = document.selectNodes("//company/employee/@first_name");
        for (Iterator iter = list.iterator();
             iter.hasNext();) {
            Attribute attribute = (Attribute)iter.next();
            System.out.println("Found //company/employee/@first_name : " + attribute);
        }
        // searching for a specific attribute value (found a match):
        list = document.selectNodes("//company/employee/@first_name=\"Mark\"");
        for (Iterator iter = list.iterator();
             iter.hasNext();) {
            Object obj = iter.next();
            System.out.println("Found //company/employee/@first_name='Mark'? : " + obj);
        }
        // searching for a specific attribute value (no match):
        list = document.selectNodes("//company/employee/@first_name=\"MarkZ\"");
        for (Iterator iter = list.iterator();
             iter.hasNext();) {
            Object obj = iter.next();
            System.out.println("Found //company/employee/@first_name='MarkZ'? : " + obj);
        }
        // inserting a new node into a DOM:
        list = document.selectNodes("//company/employee");
        for (Iterator iter = list.iterator();
             iter.hasNext();) {
            Element element = (Element) iter.next();
            Attribute attribute = element.attribute("first_name");
            System.out.println(" ** attribute value= " + attribute.getValue());
            if (attribute.getValue().equals("Mark")) {
                // add a new child node:
                element.addElement("programming_language").
                        addAttribute("favorite", "Java").
                        addAttribute("least_favorite", "Basic");
            }
        }
        // now, explore the DOM tree after adding a new element:
        System.out.println("\nAfter adding a new element to the DOM:\n");
        test.searchTree(document.getRootElement(), 0);
        // now, write out the DOM to a new file:
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter(new FileWriter("test2.xml"), format);
            writer.write(document);
            writer.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
        // we can also easily remove elements from a DOM tree:
        list = document.selectNodes("//company/employee");
        for (Iterator iter = list.iterator();
             iter.hasNext();) {
            Element element = (Element) iter.next();
            Attribute attribute = element.attribute("first_name");
            System.out.println(" ** attribute value= " + attribute.getValue());
            if (attribute.getValue().equals("Mark")) {
                boolean status = element.getParent().remove(element);
                System.out.println("status from removing element from DOM="+status);
            }
        }
        // print out the DOM top level elements to make sure the remove element worked:
        for (Iterator iter = document.getRootElement().elementIterator();
             iter.hasNext();) {
            Element element = (Element) iter.next();
            System.out.println("Child node demo: element=" + element);
        }
    }

    public Document parse(String fileName) throws DocumentException {
        SAXReader reader = new SAXReader();
        Document document = reader.read(fileName);
        return document;
    }

    public void searchTree(Element element, int depth) {
        System.out.println("parent node: depth=" + depth + ", element=" + element);
        for (int i = 0, size = element.nodeCount(); i < size; i++) {
            Node node = element.node(i);
            if (node instanceof Element) {
                System.out.println("non-leaf child node: depth=" + depth + ", element=" + element);
                searchTree((Element) node, depth + 1);
            } else {
                System.out.println("leaf child node: depth=" + depth + ", element=" + element);
            }
        }
    }

}

