package S08;

import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Locale;
import java.util.Enumeration;
import java.io.IOException;
import java.io.FileInputStream;

public class PropertyDemo {

    public static void main(String[] args) {
        // list all system properties:
        //System.getProperties().list(System.out);

        String prop1 = System.getProperty("data_path");
        String prop2 = System.getProperty("name", "John Smith"); // specify default

        // try setting some new properties:
        Properties p = new Properties(System.getProperties());
        p.setProperty("weight", "185");
        // override the previous system properties
        System.setProperties(p);
        // list all system properties:
        //System.getProperties().list(System.out);


        // second part of the demo: reading MarkDemo.properties
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream("S08/MarkDemo.properties"));
        } catch (IOException ioe) {
            ioe.printStackTrace();
        }
        Enumeration enum = properties.propertyNames();
        while (enum.hasMoreElements()) {
            String resource_name = (String) enum.nextElement();
            String resource_value = properties.getProperty(resource_name);
            System.out.println(" property:  name: " + resource_name +
                    " value: " + resource_value);
        }

        // bundles:    default (for me, English):
        ResourceBundle bundle =
                ResourceBundle.getBundle("S08.MarkDemo", Locale.getDefault());
        Enumeration keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String bundle_name = (String) keys.nextElement();
            String bundle_value = bundle.getString(bundle_name);
            System.out.println(" bundle:  name: " + bundle_name +
                    " value: " + bundle_value);
        }

        Locale locale2 = new Locale("fr", "");    // French language, any country
        System.out.println("locale2=" + locale2);
        ResourceBundle bundle2 =
                ResourceBundle.getBundle("S08.MarkDemo", locale2);
        Enumeration keys2 = bundle.getKeys();
        while (keys2.hasMoreElements()) {
            String bundle_name = (String) keys2.nextElement();
            String bundle_value = bundle2.getString(bundle_name);
            System.out.println(" bundle (French):  name: " + bundle_name +
                    " value: " + bundle_value);
        }
    }
}
