package S07;

import java.util.regex.Pattern;
import java.util.regex.Matcher;


public class RegularExpressionDemo {
    public static void main(String[] args) {
        test("dog", "The big dog was off the leash and bit the little dog.");
        test("do*", "The big dog was off the leash and bit the little dog.");
        test("do.", "The big dog was off the leash and bit the little dog.");
        test("t[^b]", "ta tb tc td");  // any char after 't' but 'b'
        test("t[^bc]", "ta tb tc td");  // any char after 't' but 'b' or 'c'
        test("t[b-c]", "ta tb tc td");  // any char after 't' that is 'b' or 'c'
        test("t[a-zA-Z]", "ta tb tC td");
        test("t[a-z&&[^b]]", "ta tb tC td"); // match a-z except for 'b'
        test("[a-zA-Z]*@[a-zA-Z]*\\.[a-zA-Z]*", "email is markw@markwatson.com now"); // match a-z except for 'b'
        test("http://[a-zA-Z]*\\.[a-zA-Z]*\\.[a-zA-Z]*", "web is http://www.markwatson.com now"); // match a-z except for 'b'
        test("http://[a-zA-Z]*\\.[a-zA-Z]*\\.[a-zA-Z]*:[0-9]*", "web is http://www.markwatson.com:8080 now"); // match a-z except for 'b'
        test("http://[a-zA-Z]*\\.[a-zA-Z]*\\.[a-zA-Z]*:[0-9]*/[/a-zA-Z0-9]", "web is http://www.markwatson.com:8080demos/nlp now"); // match a-z except for 'b'
    }
    private static void test(String regularExpressionPattern, String inputText) {
        System.out.println("\n  regular expression: " + regularExpressionPattern +
                "\n  input text: " + inputText + "\n");
        Pattern pattern = Pattern.compile(regularExpressionPattern);
        Matcher matcher = pattern.matcher(inputText);
        while(matcher.find()) {
            System.out.println("matching text: '" + matcher.group() +
                               "' starting index=" + matcher.start() +
                               ",ending index=" + matcher.end());
        }
    }
}
