package S06;

/**
 * A class with a public static method for efficiently performing
 * multiple string replacements.
 */
public final class StringUtils {
    public static void main(String[] args) {
        String s = "The bad dog ran down the street after the black cat";
        int num1 = StringUtils.countStrings(s, "dog", 0, false);
        int num2 = StringUtils.countStrings(s, "Dog", 0, true);
        int index1 = StringUtils.indexOf(s, "the", 0, false);
        int index2 = StringUtils.indexOf(s, "the", 0, true);
        String s2 = StringUtils.replace(s, "the", "THE", 0, true);
        System.out.println("num1="+num1+", num2="+num2+", index1="+index1+
                ", index2="+index2+", s2="+s2);
        StringBuffer sb = new StringBuffer("01234567890");
        sb.replace(1,5, "A");
        System.out.println("sb="+sb);
        System.out.println(indexOf(s, "the", 0, false));
        System.out.println(replace(s, "the", "THE", 0, false));
        System.out.println(replace(s, "the", "THE", 0, true));
        System.out.println(replace(s, "the", "x", 0, true));
        System.out.println(replace(s, "the", "xxxxxxxxx", 0, true));
        System.out.println(replace("short", "longer string", "x", 0, true));
    }

    public static final String replace(String s, String oldString, String replacementString, int start,
                                 boolean ignoreCase) {
        // first, see if any ocurrences of the 'oldString' are in 's':
        int numberOfOccurrences = countStrings(s, oldString, start, ignoreCase);
        if (numberOfOccurrences == 0) return s;

        int sourceStringLength = s.length();
        int oldStringLength = oldString.length();
        int replacementStringLength = replacementString.length();
        int newStringLengthCount = sourceStringLength;
        int lastPos = start;
        int lastDest;

        // calculate the maximum number of required characters (may be less):
        if (replacementStringLength > oldStringLength) {
            newStringLengthCount = sourceStringLength + numberOfOccurrences *
                    (replacementStringLength - oldStringLength);
        }
        // allocate the maximum number of characters that may be required:
        char[] buf = new char[newStringLengthCount];

        s.getChars(0, start, buf, 0);
        lastDest = start;

        while (true) {
            int nextMatchIndex = indexOf(s, oldString, lastPos, ignoreCase);
            if (nextMatchIndex == -1) break;
            s.getChars(lastPos, nextMatchIndex, buf, lastDest);
            lastDest += nextMatchIndex - lastPos;
            replacementString.getChars(0, replacementStringLength, buf, lastDest);
            lastPos = nextMatchIndex + oldStringLength;
            lastDest += replacementStringLength;
        }

        s.getChars(lastPos, sourceStringLength, buf, lastDest);

        return new String(buf, 0, lastDest - lastPos + sourceStringLength);
    }

    public static final int countStrings(String sourceString, String targetString,
                                    int start, boolean ignoreCase) {
        int targetStringLength = targetString.length();
        int occurenceCount = 0;
        if (targetStringLength > 0) {
            while (true) {
                int i = indexOf(sourceString, targetString, start, ignoreCase);
                //System.out.println(" i="+i+", start="+start+", occurenceCount="+occurenceCount);
                if (i == -1) break;
                occurenceCount++;
                start = i + targetStringLength;
            }
        }
        return occurenceCount;
    }

    public static final int indexOf(String sourceString, String targetString,
                              int start, boolean ignoreCase) {
        if (ignoreCase == false) {
            return sourceString.indexOf(targetString, start);
        } else {
            int sourceStringLength = sourceString.length();
            int targetStringLength = targetString.length();
            int stringLengthDifference = sourceStringLength - targetStringLength;
            while (start < stringLengthDifference) {
                if (sourceString.regionMatches(ignoreCase, start, targetString, 0, targetStringLength)) {
                    return start;
                }
                start++;
            }
            return -1;
        }
    }

}
