package S05;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.IOException;
import java.io.FileInputStream;

public class WordCountStreamReader extends InputStreamReader {
    public WordCountStreamReader(InputStream ins) {
        super(ins);
    }
    public int read(char[] cbuf) throws IOException {
        int count =  super.read(cbuf);
        for (int i=0; i<count; i++) {
            if (cbuf[i] == ' ')  this.count++;
        }
        return count;
    }
    public int read(char[] cbuf, int start, int num) throws IOException {
        int count =  super.read(cbuf, start, num);
        for (int i=0; i<count; i++) {
            if (cbuf[i] == ' ')  this.count++;
        }
        return count;
    }
     public int read() throws IOException {
        int character =  super.read();
        if (character == ' ')  this.count++;
        return character;
    }
    // TBD: add read(), read(char[], int, int)

    public int getWordCount() {
        if (count>0) return count+1;
        return 0;
    }
    private int count = 0;

    public static void main(String[] args) throws IOException  {
        FileInputStream fin = new FileInputStream("test.txt");
        WordCountStreamReader wcs = new WordCountStreamReader(fin);
        char[] cbuf = new char[256];
        while (wcs.read(cbuf) > 0) {}
        wcs.close();
        System.out.println("word count=" + wcs.getWordCount());
    }

}

