package S04;

import java.io.RandomAccessFile;
import java.io.IOException;
import java.io.File;
import java.io.EOFException;

/**
 * Created by IntelliJ IDEA.
 * User: markw
 * Date: May 19, 2003
 * Time: 3:21:30 PM
 * To change this template use Options | File Templates.
 */
public class RandomAccessTest {
    public static void main(String[] args) throws IOException {
        // first delete the test file if it exists:
        S01.FileUtils.deleteFilePath(new File("test.random"));
        // create a random access file for reading and writing:
        RandomAccessFile raf = new RandomAccessFile("test.random", "rw");
        // define some data to write to the file:
        byte[] data = new byte[50];
        for (int i = 0; i < 50; i++) data[i] = (byte) i;
        // by default, a random access file opens at the beginning,
        // so just write the data:
        raf.write(data, 0, 50);
        // read back the data backwards (not efficient):
        for (int i=49; i>=0; i--) {
            raf.seek(i);
            byte[] littleBuf = new byte[1];
            int count = raf.read(littleBuf, 0, 1);
            if (count != 1) {
                System.out.println("error reading random access file at i="+i);
                break;
            }
            System.out.println("at i=" + i + ", byte read from file=" + littleBuf[0]);
        }
        raf.close();
    }
}
