/**
 *   Copyright 2000, 2001, and 2002 by Mark Watson.  All rights reserved.
 *
 *   This software can only be used in accordance with the License Agreements
 *   distributed with the KnowledgeBooks.com Java NLP User's Guide, or special
 *   agreements made between license holders and Mark Watson.
 *
 *   This copyright statement can not be legally removed from this source file.
 */


package S03;

import java.io.*;
import java.util.*;

/**
 * Demonstration of serializing Java objects
 */
public class SerializationTest {


    public static void main(String[] args) throws Exception {
        SerializationTest test = new SerializationTest();
        test.writeSerializedData();
        test.readSerializedData();
    }


    public void writeSerializedData() throws IOException {
        Hashtable testHash = new Hashtable();
        Vector testVector = new Vector();
        testHash.put("cat", "dog");
        testVector.add(new Float(3.14159f));
        DemoClass demoClass = new DemoClass();
        demoClass.setName("Mark");
        Hashtable hash = demoClass.getAHashtable();
        hash.put("cat", "dog");
        FileOutputStream ostream = new FileOutputStream("test.ser");
        ObjectOutputStream p = new ObjectOutputStream(ostream);
        p.writeObject(testHash);
        p.writeObject(testVector);
        p.writeObject(demoClass);
        p.close();
    }

    public void readSerializedData() throws IOException, ClassNotFoundException {
            InputStream ins = new java.io.FileInputStream("test.ser");
            if (ins == null) {
                System.out.println("Failed to open 'test.ser'");
                System.exit(1);
            } else {
                ObjectInputStream p = new ObjectInputStream(ins);
                // read the first object from the input stream and see what type it is:
                Object o1 = p.readObject();
                System.out.println("Type of first object in input stream=" + o1.getClass());
                // to be safe, we could make sure that the first object is really a Hashtable:
                // meant to be an example of checking class tpye after deserialization)
                if (o1.getClass() == Hashtable.class) {
                    Hashtable h = (Hashtable)o1;
                    Enumeration keys = h.keys();
                    while (keys.hasMoreElements()) {
                        String key = (String)keys.nextElement();
                        String value = (String)h.get(key);
                        System.out.println("Hashtable key/value: " + key + "/" + value);
                    }
                }
                // the second object is a Vector:
                Vector v = (Vector)p.readObject();
                for (int i=0, size=v.size(); i<size; i++) {
                    System.out.println("next vector element from object stream: " + v.get(i));
                }
                // the third object in the input object stream is an instance of DemoClass:
                DemoClass demo = (DemoClass)p.readObject();
                System.out.println("demo class name value="+demo.getName());
                Hashtable hash = demo.getAHashtable();
                // demonstrate that a "transient" variable is not initialized
                // during deserialization:
                System.out.println("a null hash table:"+ hash);
            }
    }
}

class DemoClass implements Serializable {
    private String name = "";
    transient private Hashtable aHashtable = new Hashtable();
    public DemoClass() {
        System.out.println("entering DemoClass() default constructor");
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Hashtable getAHashtable() {
        return aHashtable;
    }

    public void setAHashtable(Hashtable aHashtable) {
        this.aHashtable = (Hashtable)aHashtable.clone();
    }
}

