/**
 *   Copyright 2000, 2001, 2002, and 2003 by Mark Watson.  All rights reserved.
 */

package S02;

import java.io.*;
import java.util.*;
import java.util.zip.*;

public class ReadWriteZipFiles {

    public static void main(String[] args) throws IOException {
       ReadWriteZipFiles test = new ReadWriteZipFiles();
        test.writeZipFile();
        test.readZipFile();
    }

    void writeZipFile() throws IOException {
        FileOutputStream fStream = new FileOutputStream("test.zip");
        ZipOutputStream zStream = new ZipOutputStream(fStream);

        // create a Zip Entry and put it into the archive. add data later:
        ZipEntry fileEntry = new ZipEntry("test.txt");
        zStream.putNextEntry(fileEntry);
        // now add data from the contents of file "test.txt":
        byte[] buf = new byte[16384]; // assume this is large enough to hold the file
        FileInputStream inStream = new FileInputStream("test.txt");
        int readCount = inStream.read(buf);
        zStream.write(buf, 0, readCount);
        zStream.closeEntry();

        // lets add another entry, this time from text in a string:
        ZipEntry stringEntry = new ZipEntry("string-entry");
        zStream.putNextEntry(stringEntry);
        // now add data from the contents the string 's':
        String s = "This is\ntest data.\n";
        zStream.write(s.getBytes(), 0, s.length());
        zStream.closeEntry(); // closes stringEntry

        // finally, close the zip stream:
        zStream.close();

    }

    void readZipFile() throws IOException {
            ZipFile zipFile = new ZipFile("test.zip");
            Enumeration entries = zipFile.entries();
            byte[] buf = new byte[2048];
            while (entries.hasMoreElements()) {
                ZipEntry entry = (ZipEntry) entries.nextElement();

                if (entry.isDirectory()) {
                    System.err.println("Extracting directory: " + entry.getName());
                    // Note: you can create directory files with this name:
                    //  File fdir = new File(entry.getName());
                    //  fdir.mkdir();
                    continue;
                }

                System.out.println("Extracting file: " + entry.getName());
                InputStream is = zipFile.getInputStream(entry);
                while (true) {
                    int count = is.read(buf);
                    if (count < 1) break;
                    // add your code here to process 'count' bytes of data:

                    //System.out.println("zip entry contents: " + new String(buf, 0, count));
                }
                is.close();
            }

            zipFile.close();
    }

}
