/**
 *   Copyright 2000, 2001, 2002, and 2003 by Mark Watson.  All rights reserved.
 */

package S02;

import java.io.*;
import java.util.*;
import java.util.jar.JarOutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;


public class ReadWriteJarFiles {

    public static void main(String[] args) throws IOException {
        ReadWriteJarFiles test = new ReadWriteJarFiles();
        test.writeJarFile();
        test.readJarFile();
    }

    void writeJarFile() throws IOException {
        FileOutputStream fStream = new FileOutputStream("test.jar");
        JarOutputStream jStream = new JarOutputStream(fStream);
        // write an entry using the file test.txt:
        FileInputStream fis = new FileInputStream("test.txt");
        BufferedInputStream bis = new BufferedInputStream(fis);

        // create a Jar Entry and put it into the archive. add data later:
        JarEntry fileEntry = new JarEntry("test.txt");
        jStream.putNextEntry(fileEntry);
        // now add data from the contents of file "test.txt":
        byte[] buf = new byte[16384]; // assume this is large enough to hold the file
        FileInputStream inStream = new FileInputStream("test.txt");
        int readCount = inStream.read(buf);
        jStream.write(buf, 0, readCount);
        jStream.closeEntry();

        // lets add another entry, this time from text in a string:
        JarEntry stringEntry = new JarEntry("string-entry");
        jStream.putNextEntry(stringEntry);
        // now add data from the contents the string 's':
        String s = "This is\ntest data.\n";
        jStream.write(s.getBytes(), 0, s.length());
        jStream.closeEntry(); // closes stringEntry

        // finally, close the zip stream:
        jStream.close();

    }

    void readJarFile() throws IOException {
        JarFile zipFile = new JarFile("test.jar");

        Enumeration entries = zipFile.entries();
        byte[] buf = new byte[2048];
        while (entries.hasMoreElements()) {
            JarEntry entry = (JarEntry) entries.nextElement();

            if (entry.isDirectory()) {
                System.err.println("Extracting directory: " + entry.getName());
                // Note: you can create directory files with this name:
                //  File fdir = new File(entry.getName());
                //  fdir.mkdir();
                continue;
            }

            System.out.println("Extracting file: " + entry.getName());
            InputStream is = zipFile.getInputStream(entry);
            int start = 0;
            while (true) {
                int count = is.read(buf);
                if (count < 1) break;
                // add your code here to process 'count' bytes of data:

                //System.out.println("zip entry contents: " + new String(buf, 0, count));
            }
            is.close();
        }

        zipFile.close();
    }

}
